<?php
use WpBookingPro\Factory;
use WpBookingPro\Html\WpBookingProHtmlWooPanel;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);
$list_requestpayment = array('manual','auto');

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>"
         class="<?php echo (esc_attr($class)); ?> field-requestpayment-<?php echo (esc_attr($name_format)) ?> field-requestpayment">
        <select class="form-control list-requestpayment" <?php echo ($multiple ? ' multiple ' : ""); ?>>
            <option value=""> <?php esc_html_e('Select request payment','wpbookingpro') ?></option>
			<?php foreach ($list_requestpayment as $requestpayment) { ?>
                <option <?php echo ($requestpayment == $value ? " selected " : "") ?>
                        value="<?php echo (esc_attr($requestpayment)); ?>"><?php echo (esc_html(ucfirst($requestpayment))); ?></option>
			<?php } ?>
        </select>
        <input type="hidden" name="<?php echo (esc_attr($name)); ?>">
    </div>
<?php
$doc = Factory::getDocument();
WpBookingProHtmlWooPanel::load_jquery_library('select2');
$doc->addLessStylesheet('admin_woopanel/app/layouts/WooBooking/form/field/requestpayment/requestpayment.less');
$doc->addScriptApplySelector('.field-requestpayment','field_requestpayment',array(
    "field_name"=>  $name,
    "value"=> $value
),'admin_woopanel/app/layouts/WooBooking/form/field/requestpayment/requestpayment.jquery.js');
