<?php

use WpBookingPro\Factory;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingProHtmlBackendAlias::load_jquery_library('select2');


$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$data = $displayData['field']->getForm()->getData();
$list = get_pages();
$list_time = [];
$list_page_id = [];
if (!is_array($value)) {
	$list_page_id[] = $value;
} else {
	$list_page_id = $value;
}



?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="<?php esc_attr_e($class); ?> field-pages">
        <select name="<?php esc_attr_e($name); ?>" required="<?php esc_attr_e($required) ?>" <?php echo ($multiple ? ' multiple ' : ""); ?>
                class="list-page">
            <option value=""><?php esc_attr_e('Select page','wpbookingpro') ?></option>
			<?php foreach ($list as $item) { ?>
                <option <?php echo (in_array($item->ID, $list_page_id) ? ' selected ' : null) ?>
                        value="<?php esc_attr_e($item->ID); ?>"><?php esc_html_e($item->post_title); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin_woopanel/app/layouts/WooBooking/form/field/pages/pages.less');
$doc->addScriptApplySelector("#$id_by_name",'field_pages',array(
),'admin_woopanel/app/layouts/WooBooking/form/field/pages/pages.jquery.js');