<?php

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model as ModelAlias;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Html\WpBookingProHtmlWooPanel as WpBookingProHtmlWooPanelAlias;
use WpBookingPro\Language\Text;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

WpBookingProHtmlWooPanelAlias::load_jquery_library('select2');



$doc = Factory::getDocument();
$orderstatusModel= ModelAlias::getInstance('orderstatuss');
$list=$orderstatusModel->getList();
$id_by_name = $id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="field-orderstatus">
        <div class="wrapper-orderstatus">
            <select class="orderstatus" name="<?php esc_attr_e($name); ?>">
                <?php foreach ($list as $item){ ?>
                    <option <?php echo ($item->open_source_order_status_id===$value?' selected ':'') ?> value="<?php esc_attr_e($item->open_source_order_status_id); ?>"><?php esc_html_e($item->name); ?></option>
                <?php } ?>
            </select>
        </div>
    </div>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/layouts/WooBooking/form/field/orderstatus/orderstatus.less');
$doc->addScriptApplySelector("#$id_by_name",'field_orderstatus',array(
    "input_name"=>  $name,
),'admin_woopanel/app/layouts/WooBooking/form/field/orderstatus/jquery.orderstatus.js');
