<?php
use WpBookingPro\Language\Text;
use WpBookingPro\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

WpBookingProHtmlBackend::load_jquery_library('select2');



$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$args = array();
$products = wc_get_products($args);
?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="<?php esc_attr_e($class); ?> field-opensourcelinkid">
        <div class="wrapper-field-opensourcelinkid">
            <select name="<?php esc_attr_e($name); ?>" required="<?php esc_attr_e($required) ?>"
                    class="open-source-link">
                <option value=""><?php esc_html_e('Select product','wpbookingpro') ?></option>
				<?php foreach ($products as $product) { ?>
                    <option <?php echo ($product->get_id() == $value ? ' selected ' : null) ?>
                            value="<?php esc_attr_e($product->get_id()); ?>"><?php esc_html_e($product->get_name()); ?></option>
				<?php } ?>
            </select>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addScriptApplySelector('.field-opensourcelinkid','field_opensourcelinkid',array(
        "step"=>  (int)$step,
        "tool_check"=>  json_encode(array_reverse($toolChecked)),
    )
    ,'admin/nb_apps/nb_woobooking/layouts/WooBooking/form/field/opensourcelinkid/opensourcelinkid.jquery.js');