<?php
use WpBookingPro\Factory;
use WpBookingPro\Utilities\Utility;
use WpBookingProAdminWooPanel\app\helpers\AdminHelper;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$data = $field->getForm()->getData();
$a_title = $data->def('name');
$fullname = ucwords($data->def('first_name') . ' ' . $data->def('last_name'));
$image = $data->def('image_location_avatar');
$a_title = Utility::clean($a_title);
$a_title = Utility::clean_all_space_to_single_space($a_title);

$check_user_demo = AdminHelper::checkUserDemo();
$uploads = wp_upload_dir();
$check_image_size = AdminHelper::checkImageData($uploads['baseurl'], $value);
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> field-fullimage">
        <div class="wrapper-field-fullimage">
            <div class="header">
                <i class="far fa-plus-square upload"></i>
                <div>
                    <?php if(!$check_user_demo['is_demo']) {?>
                        <img class="img-fullimage" src="<?php echo (esc_url($value ? Factory::getRootUrlPlugin().$value : Factory::getRootUrlPlugin().$default)) ?>" alt="img-fullimage" />
                    <?php } else {?>
                        <?php if($check_image_size) {?>
                            <img class="img-fullimage" src="<?php echo (esc_url($value ? $uploads['baseurl'].'/'.$value : Factory::getRootUrlPlugin().$default)) ?>" alt="img-fullimage" />
                        <?php } else {?>
                            <img class="img-fullimage" src="<?php echo (esc_url($value ? Factory::getRootUrlPlugin().$value : Factory::getRootUrlPlugin().$default)) ?>" alt="img-fullimage" />
                        <?php } ?>
                    <?php } ?>
                </div>
            </div>
            <input type="file" class="upload"  name="<?php esc_html_e($name); ?>" style="display: none"/>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStylesheet('admin_woopanel/app/layouts/WooBooking/form/field/fullimage/fullimage.less');
$doc->addScriptApplySelector(".field-fullimage",'field_fullimage',array(
),'admin_woopanel/app/layouts/WooBooking/form/field/fullimage/fullimage.jquery.js');