<?php
use WpBookingPro\Factory;
use WpBookingPro\Html\WpBookingProHtmlBackend;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);


$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);
$input = Factory::getInput();
$id = $input->getInt('id',0);



?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-editpass-<?php echo (esc_attr($name_format)) ?> field-editpass">
        <?php if($id > 0 && trim($id) != '') {?>
        <div class="pass-input old-pass-input">
            <label for="old-pass"><?php esc_html_e('Old password','wpbookingpro');?></label>
            <div class="pass-input-item">
                <input type="password"  id="old-pass" name="old_pass">
                <i class="far fa-check-circle" style="display: none"></i>
                <label class="error-old-pass" style="display: none"><?php esc_html_e('Incorrect password','wpbookingpro');?></label>
            </div>
        </div>
        <?php }?>
        <div class="pass-input new-pass-input">
            <label for="new-pass"><?php esc_html_e('New password','wpbookingpro');?></label>
            <div class="pass-input-item">
                <input type="password"  id="new_pass" name="new_pass">
                <i class="far fa-check-circle" style="display: none"></i>
                <label class="error-new-pass" style="display: none"><?php esc_html_e('New password must be other old password','wpbookingpro');?></label>
                <label class="error" style="display: none"><?php esc_html_e('Minimum 8 characters, at least 1 uppercase letter, 1 lowercase letter, 1 number and 1 special character','wpbookingpro');?></label>
            </div>
        </div>
        <div class="pass-input renew-pass-input">
            <label for="repeat-new-pass"><?php esc_html_e('Confirm new password','wpbookingpro');?></label>
            <div class="pass-input-item">
                <input type="password"  id="repeat-new-pass" name="confirm_new_pass">
                <i class="far fa-check-circle" style="display: none"></i>
                <label class="error-renew-pass" style="display: none"><?php esc_html_e('Please make sure your password match','wpbookingpro');?></label>
            </div>
        </div>
        <input type="hidden" name="<?php echo (esc_attr($name)); ?>">
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStylesheet('admin_woopanel/app/layouts/WooBooking/form/field/editpass/editpass.less');
$doc->addScriptApplySelector('.field-editpass','field_editpass',array(
),'admin_woopanel/app/layouts/WooBooking/form/field/editpass/editpass.jquery.js');
