<?php

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
use WpBookingPro\Language\Text;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingProHtmlBackendAlias::load_jquery_library('auto_numeric');
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin_woopanel/app/layouts/WooBooking/form/field/customaddress/customaddress.less');
$modelLocation = Model::getInstance('location');
$list = $modelLocation->getList();
$id_by_name = "element_field_". $name;
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="field-custom-address">
        <label class="label-select-address"><?php esc_attr_e('Select address','wpbookingpro') ?></label>
        <div class="block-select-address">
            <select name="<?php esc_html_e($name); ?>" class="list-address">
                <option value=""><?php esc_attr_e('Custom address','wpbookingpro') ?></option>
                <?php foreach ($list as $item) { ?>
                    <option <?php echo($value == $item->id ? ' selected ' : '') ?>
                            value="<?php esc_html_e($item->id); ?>"><?php esc_html_e($item->address); ?></option>
                <?php } ?>
            </select>
        </div>
        <div class="wrapper-custom-address">
            <div class="row">
                <div class="col-md-12">
                    <input type="text" class="form-control custom-address" name="<?php esc_html_e($name_custom_address) ?>" placeholder="<?php esc_attr_e('Custom address','wpbookingpro') ?>"  />
                </div>
            </div>
        </div>
    </div>
<?php
$doc->addScriptApplySelector('#'.$id_by_name,'field_customaddress',array(
    "input_name"=>  $name,
),'admin_woopanel/app/layouts/WooBooking/form/field/customaddress/jquery.customaddress.js');
