<?php
use WpBookingPro\Factory;
use WpBookingPro\Html\WpBookingProHtmlWooPanel;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;
use WpBookingProAdminWooPanel\app\helpers\AdminHelper;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);

$list_currency = AdminHelper::getListCurrencySupported();
$list_currency_used = AdminHelper::getListCurrencyUsed();

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>"
         class="<?php echo (esc_attr($class)); ?> field-currency-<?php echo (esc_attr($name_format)) ?> field-currency">
        <select name="<?php echo (esc_attr($name)); ?>" <?php echo ($multiple ? ' multiple ' : ""); ?> class="form-control list-currency">
            <option value="" disabled> <?php esc_html_e('Select currency','wpbookingpro') ?></option>
			<?php foreach ($list_currency as $currency) { ?>
                <option <?php echo (esc_attr($currency == $value ? " selected " : "")) ?>
                        value="<?php echo (esc_attr($currency)); ?>" <?php echo (esc_attr(in_array($currency, $list_currency_used)? 'disabled':''))?>>
                    <?php echo (esc_html($currency)); ?>
                </option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
WpBookingProHtmlWooPanel::load_jquery_library('select2');
$doc->addLessStylesheet('admin_woopanel/app/layouts/WooBooking/form/field/currency/currency.less');
$doc->addScriptApplySelector('.field-currency','field_currency',array(
    "field_name"=>  $name,
),'admin_woopanel/app/layouts/WooBooking/form/field/currency/currency.jquery.js');
