<?php
use WpBookingPro\Factory;
use WpBookingPro\Utilities\Utility;
use WpBookingProAdminWooPanel\app\helpers\AdminHelper;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
$id_by_name = "element_field_" . $name;
$data = $field->getForm()->getData();

$check_user_demo = AdminHelper::checkUserDemo();
$uploads = wp_upload_dir();

$check_image_size = AdminHelper::checkImageData($uploads['baseurl'], $value);

?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> field-cover">
        <div class="wrapper-field-cover">
            <div class="header">
                <i class="far fa-plus-square upload"></i>
                <div>
                    <?php if(!$check_user_demo['is_demo']) {?>
                        <img class="img-avatar" src="<?php echo (esc_url($value ? Factory::getRootUrlPlugin().$value : Factory::getRootUrlPlugin().$default)) ?>" alt="avatar" />
                    <?php } else {?>
                        <?php if($check_image_size) {?>
                            <img class="img-avatar" src="<?php echo (esc_url($value ? $uploads['baseurl'].'/'.$value : Factory::getRootUrlPlugin().$default)) ?>" alt="avatar" />
                        <?php } else {?>
                            <img class="img-avatar" src="<?php echo (esc_url($value ? Factory::getRootUrlPlugin().$value : Factory::getRootUrlPlugin().$default)) ?>" alt="avatar" />
                        <?php } ?>
                    <?php } ?>
                </div>
            </div>
            <input type="file" class="upload"  name="<?php esc_html_e($name); ?>" style="display: none"/>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStylesheet('admin_woopanel/app/layouts/WooBooking/form/field/cover/cover.less');
$doc->addScriptApplySelector("#$id_by_name",'field_cover',array(
),'admin_woopanel/app/layouts/WooBooking/form/field/cover/cover.jquery.js');