"use strict";
(function ($) {
    $.view_list_states = function (element, options) {
        let defaults = {

        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('#example').DataTable({
                "scrollX": true,
                language: {
                    paginate: {
                        previous: "<i class=\"icon-nb-arrow\"></i>",
                        next: "<i class=\"icon-nb-arrow\"></i>"
                    }
                },
                drawCallback: function () {
                    $element.find('input[type="checkbox"]').iCheck({
                        checkboxClass: 'icheckbox_square-red',
                        radioClass: 'iradio_square-red',
                        increaseArea: '10%'
                    });
                }
            });
            $element.find('input[type="search"]').attr('placeholder', 'Search');
            $element.find("#example_filter label").contents()[0].remove();
            $element.find('input[type="checkbox"]').iCheck({
                checkboxClass: 'icheckbox_square-red',
                radioClass: 'iradio_square-red',
                increaseArea: '10%'
            });

            $element.find('select#searchByVendor').select2();
            $element.find('select#searchByVendor').on('change', function () {
                let $form = $(this).closest('form[name="admin_woopanel-form"]');
                $form.submit();
            });


        }
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.view_list_states = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_list_states')) {
                let plugin = new $.view_list_states(this, options);
                $(this).data('view_list_states', plugin);
            }
        });
    }
})(jQuery);
