"use strict";
(function ($) {
    $.view_list_service = function (element, options) {
        let defaults = {
            list_service_by_category: [],
            html_service_item: '',
            html_category_item: ''
        };
        let plugin = this;
        plugin.settings = {};
        let $element = $(element);
        plugin.get_ordering = function(id, result) {
            return result.findIndex(function (item) {
                return parseInt(item) === id ;
            });
        };
        plugin.update_order_category = function (result) {
            let list_ordering = [];
            $element.find('.wrapper-category .block-category-item').each(function (index, item) {
                let id = $(item).data('id');
                let ordering = plugin.get_ordering(id, result);

                let ordering_item = {
                    id: id,
                    ordering: ordering + 1
                };
                list_ordering.push(ordering_item);

            });
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: {
                    task: "categories.sorting",
                    list_ordering: list_ordering
                },
                beforeSend: function () {
                    $('body').loadingModal();
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
                success: function (response) {
                }
            });
        };
        plugin.update_order_service = function ($item,result) {
            let category_id = $item.data('category_id');
            let list_ordering = [];
            $element.find(`.list-service-by-category[data-category_id="${category_id}"] .wrapper-service-item`).each(function (index, item) {
                let id = $(item).data('id');
                let ordering = plugin.get_ordering(id, result);
                let ordering_item = {
                    id: id,
                    ordering: ordering + 1
                };
                list_ordering.push(ordering_item);
            });
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: {
                    task: "services.sorting",
                    list_ordering: list_ordering
                },
                beforeSend: function () {
                    $('body').loadingModal();
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
                success: function (response) {

                }
            });
        };
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('input[type="checkbox"]').iCheck({
                checkboxClass: 'icheckbox_square-red',
                radioClass: 'iradio_square-red',
                increaseArea: '20%'
            });
            $element.find('.wrapper-category').sortable({
                stop: function (event, ui) {
                    let result = $(this).sortable('toArray', {attribute: 'data-id'});
                    plugin.update_order_category(result);
                }
            });
            $element.find('.wrapper-category-item').on('click', function (e) {
                $element.find('.wrapper-category-item').removeClass('active');
                $(this).addClass('active');
            });
            $element.find('.wrapper-category-item:first').trigger('click');
            $element.find('.block-category-item').on('click', function (e) {
                let $current_tab = $(this);
                let data_href = $current_tab.attr('href');
                let $list_service = $element.find('.list-service-by-category');
                $.each($list_service, function (index, item) {
                    let id = '#' +  $(item).data('id');
                    $(item).hide();
                    if(id === data_href){
                        $(item).show();
                    }
                })
            });
            $element.find('.list-service-by-category').sortable({
                axis: "y",
                stop: function (event, ui) {
                    let result = $(this).sortable('toArray', {attribute: 'data-id'});
                    plugin.update_order_service(ui.item,result);
                }
            });
            $element.find('.wrapper-button-category a').on('click', function () {
                let href = $(this).attr('href');
                window.location.replace(href)
            });
            $element.find('select#searchByVendor').select2();
            $element.find('select#searchByVendor').on('change', function () {
                let $form = $(this).closest('form[name="admin_woopanel-form"]');
                $form.submit();
            });

        };
        plugin.init();
    };
    $.fn.view_list_service = function (options) {
        return this.each(function () {
            if (undefined === $(this).data('view_list_service')) {
                let plugin = new $.view_list_service(this, options);
                $(this).data('view_list_service', plugin);
            }
        });
    }
})(jQuery);