"use strict";
(function ($) {
    $.view_form_user = function (element, options) {
        let defaults = {
            old_pass_ok:false,
            new_pass_ok:false,
            confirm_new_pass_ok:false,
            is_new_user:'',
            id:''
        };
        let plugin = this;
        plugin.settings = {};
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let is_new_user = plugin.settings.is_new_user;
            let id = plugin.settings.id;

            if(is_new_user) {
                let checkNewPass = plugin.debounce(function () {
                    var output = plugin.convert_data_form();
                    let dataObj = {};
                    $(output).each(function(i, field){
                        dataObj[field.name] = field.value[0];
                    });
                    if(/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[@$!%*?&])[A-Za-z\d@$!%*?&]{8,}$/.test(dataObj.new_pass)) {
                        $element.find('.new-pass-input i').show();
                        $element.find('.new-pass-input .error').hide();
                        plugin.settings.new_pass_ok = true;
                    } else {
                        $element.find('.new-pass-input i').hide();
                        $element.find('.new-pass-input .error').show();
                        plugin.settings.new_pass_ok = false;
                    }

                }, 500);

                $element.find('input[name="new_pass"]').on('keyup', checkNewPass);
            } else {
                let checkOldUserPass = plugin.debounce(function () {
                    var output = plugin.convert_data_form();
                    let dataObj = {};
                    $(output).each(function(i, field){
                        dataObj[field.name] = field.value[0];
                    });
                    $.ajax({
                        url: wpbookingpro_root_url+wpbookingpro_api_task,
                        type: 'POST',
                        dataType: 'json',
                        data: {
                            dataObj: dataObj,
                            id:id,
                            task: "user.check_old_user_pass",
                        },
                        beforeSend: function() {
                            $('body').loadingModal();
                        },
                        success: function(res) {
                            res = JSON.parse(res)
                            let data = res.data;
                            plugin.settings.old_pass_ok = data;
                            if(data) {
                                $element.find('.old-pass-input i').show();
                                $element.find('.old-pass-input .error-old-pass').hide();

                            } else {
                                $element.find('.old-pass-input i').hide();
                                $element.find('.old-pass-input .error-old-pass').show();
                            }
                        },
                        error: function(xhr) { // if error occured

                        },
                        complete: function() {
                            $('body').loadingModal('destroy');

                        },
                    })
                },3000);
                $element.find('input[name="old_pass"]').on('keyup', checkOldUserPass)

                let checkNewPass = plugin.debounce(function () {
                    var output = plugin.convert_data_form();
                    let dataObj = {};
                    $(output).each(function(i, field){
                        dataObj[field.name] = field.value[0];
                    });
                    if(dataObj.new_pass !== dataObj.old_pass) {
                        if(/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[@$!%*?&])[A-Za-z\d@$!%*?&]{8,}$/.test(dataObj.new_pass)) {
                            $element.find('.new-pass-input i').show();
                            $element.find('.new-pass-input .error-new-pass').hide();
                            $element.find('.new-pass-input .error').hide();
                            plugin.settings.new_pass_ok = true;
                        } else {
                            $element.find('.new-pass-input i').hide();
                            $element.find('.new-pass-input .error-new-pass').hide();
                            $element.find('.new-pass-input .error').show();
                            plugin.settings.new_pass_ok = false;
                        }

                    } else {
                        $element.find('.new-pass-input i').hide();
                        $element.find('.new-pass-input .error-new-pass').show();
                        $element.find('.new-pass-input .error').hide();
                        plugin.settings.new_pass_ok = false;
                    }

                }, 500);

                $element.find('input[name="new_pass"]').on('keyup', checkNewPass);
            }


            var checkConfirmNewPass = plugin.debounce(function () {
                var output = plugin.convert_data_form();
                let dataObj = {};
                $(output).each(function(i, field){
                    dataObj[field.name] = field.value[0];
                });
                if(dataObj.new_pass !== dataObj.confirm_new_pass) {
                    $element.find('.renew-pass-input i').hide();
                    $element.find('.renew-pass-input .error-renew-pass').show();
                    plugin.settings.confirm_new_pass_ok = false;
                } else {
                    $element.find('.renew-pass-input i').show();
                    $element.find('.renew-pass-input .error-renew-pass').hide();
                    plugin.settings.confirm_new_pass_ok = true;
                }

                if(is_new_user) {
                    if(plugin.settings.new_pass_ok === true && plugin.settings.confirm_new_pass_ok === true) {
                        $element.find(`input[name="user_pass"]`).val(dataObj.confirm_new_pass)
                    } else {
                        $element.find(`input[name="user_pass"]`).val('')
                    }
                } else {
                    if(plugin.settings.old_pass_ok === true && plugin.settings.new_pass_ok === true && plugin.settings.confirm_new_pass_ok === true) {
                        $element.find(`input[name="user_pass"]`).val(dataObj.confirm_new_pass)
                    } else {
                        $element.find(`input[name="user_pass"]`).val('')
                    }
                }



            }, 500);

            $element.find('input[name="confirm_new_pass"]').on('keyup', checkConfirmNewPass);


        };
        plugin.convert_data_form = function() {
            var dataArray = $element.find('form[name="admin_woopanel-form"]').serializeArray();
            var output = [];
            dataArray.forEach(function(item) {
                var existing = output.filter(function(v, i) {
                    return v.name == item.name;
                });
                if (existing.length) {
                    var existingIndex = output.indexOf(existing[0]);
                    output[existingIndex].value = output[existingIndex].value.concat(item.value);
                } else {
                    if (typeof item.value == 'string')
                        item.value = [item.value];
                    output.push(item);
                }
            });
            return output;
        };
        plugin.debounce = function(func, wait) {
            var timeout;

            return function() {
                var context = this,
                    args = arguments;

                var executeFunction = function() {
                    func.apply(context, args);
                };

                clearTimeout(timeout);
                timeout = setTimeout(executeFunction, wait);
            };
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }
    $.fn.view_form_user = function (options) {
        return this.each(function () {
            if (undefined === $(this).data('view_form_user')) {
                let plugin = new $.view_form_user(this, options);
                $(this).data('view_form_user'
                    , plugin);
            }
        });
    }
})(jQuery);
