"use strict";
(function ($) {
    $.view_form_payment = function (element, options) {
        let defaults = {
        };
        let plugin = this;
        plugin.settings = {};
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('input[type="radio"]').iCheck({
                checkboxClass: 'icheckbox_square-red',
                radioClass: 'iradio_square-red',
                increaseArea: '20%'
            });
            $element.find('input[name="radio-select"]').on('ifChanged', function () {
                let val = $(this).val();
                $element.find('input[name="payment"]').val(val);
            });
            $element.find('form[name="admin-form"]').each(function (e) {
                $(this).validate({
                    ignore: ""
                });
            });
            $element.find('.btn-payment-modal-now').on('click', function() {
                let $form = $(this).closest('form[name="admin_woopanel-form"]');
                let payment = $form.find('input[name="payment"]').val();
                if(payment.trim() === '') {
                    $.alert({
                        title:'',
                        content: `<div class="wrapper-alert">
                                        <span class="title-box">Check your information</span>
                                        <span class="content-box">Please select payment method</span>
                                   </div>
                                   <i class="icon-nb-hand"></i>`,
                        container:'.block-alert',
                        buttons: {
                            formSubmit: {
                                text: '<i class="icon-nb-close"></i>',
                                btnClass: 'btn-red',
                            }
                        }
                    });
                    return false;
                }
                $form.submit();
            })
            
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }
    $.fn.view_form_payment = function (options) {
        return this.each(function () {
            if (undefined === $(this).data('view_form_payment')) {
                let plugin = new $.view_form_payment(this, options);
                $(this).data('view_form_payment'
                    , plugin);
            }
        });
    }
})(jQuery);
