"use strict";
(function ($) {
    $.view_config_install = function (element, options) {
        let defaults = {
            tool_check: [],
            all_tool_check: [],
            list_lang_install: [],
            step: 1,
            total_media: 100
        };
        let plugin = this;
        plugin.settings = {};
        let $element = $(element);
        plugin.show_dialog_download = function () {
            waitingDialog.show('Loading...',{

                // if the option is set to boolean false, it will hide the header and "message" will be set in a paragraph above the progress bar.
                // When headerText is a not-empty string, "message" becomes a content above the progress bar and headerText string will be set as a text inside the H3;
                headerText: `Start download media`,

                // this will generate a heading corresponding to the size number
                headerSize: 3,

                // extra class(es) for the header tag
                headerClass: '',

                // bootstrap postfix for dialog size, e.g. "sm", "m"
                dialogSize: 'm',
                width:"100%",

                // bootstrap postfix for progress bar type, e.g. "success", "warning";
                progressType: '',

                // determines the tag of the content element
                contentElement: 'p',

                // extra class(es) for the content tag
                contentClass: 'content'

            });

        };
        plugin.get_total_media_download = function () {
            let all_tool_check = plugin.settings.all_tool_check;
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: {
                    task: `install.get_total_media_download`,
                    all_tool_check: all_tool_check
                },
                beforeSend: function () {
                    waitingDialog.show('Loading...',{

                        // if the option is set to boolean false, it will hide the header and "message" will be set in a paragraph above the progress bar.
                        // When headerText is a not-empty string, "message" becomes a content above the progress bar and headerText string will be set as a text inside the H3;
                        headerText: `get total media download`,

                        // this will generate a heading corresponding to the size number
                        headerSize: 3,

                        // extra class(es) for the header tag
                        headerClass: '',

                        // bootstrap postfix for dialog size, e.g. "sm", "m"
                        dialogSize: 'm',
                        width:"100%",

                        // bootstrap postfix for progress bar type, e.g. "success", "warning";
                        progressType: '',

                        // determines the tag of the content element
                        contentElement: 'p',

                        // extra class(es) for the content tag
                        contentClass: 'content'

                    });

                },
                success: function (response) {
                    waitingDialog.hide();
                    response = JSON.parse(response);
                    let data_response = response.data;
                    data_response = JSON.parse(data_response);
                    if (data_response.result === "success") {
                        let list_media=data_response.list_media;
                        plugin.settings.total_media=list_media.length;
                        plugin.show_dialog_download();
                        plugin.show_import_media_sample(list_media);
                    } else {
                        $.alert({
                            title: 'Error',
                            content: 'there are some error please contact admin !',
                        });
                    }
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function (response) {
                },
            });

        };
        plugin.show_import_media_sample = function (list_media) {
            let total_media=plugin.settings.total_media;
            let percent=100-(list_media.length/total_media)*100;
            let current_media=list_media.pop();
            waitingDialog.set_percent(`${percent}%`);
            waitingDialog.set_content(current_media);
            if(list_media.length===0){
                waitingDialog.hide();
                plugin.setup_follow_tool();
                return;
            }
            let all_tool_check = plugin.settings.all_tool_check;
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: {
                    task: `install.download_current_media`,
                    all_tool_check: all_tool_check,
                    current_media: current_media
                },
                beforeSend: function () {

                },
                success: function (response) {
                    response = JSON.parse(response);
                    let data_response = response.data;
                    data_response = JSON.parse(data_response);
                    if (data_response.result === "success") {
                        plugin.show_import_media_sample(list_media);
                    } else {
                        $.alert({
                            title: 'Error',
                            content: 'there are some error please contact admin !',
                        });
                    }
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function (response) {
                },
            });


        };
        plugin.setup_follow_tool = function () {
            let list_task = plugin.settings.tool_check;
            let all_tool_check = plugin.settings.all_tool_check;
            let list_lang_install = plugin.settings.list_lang_install;

            if (list_task.length > 0) {
                let current_task = list_task.pop();
                if(current_task==="import_media_sample"){
                    plugin.get_total_media_download();
                }else{
                    $.ajax({
                        type: "POST",
                        dataType: "json",
                        url: wpbookingpro_root_url + wpbookingpro_api_task,
                        data: {
                            task: `install.${current_task}`,
                            all_tool_check: all_tool_check
                        },
                        beforeSend: function () {
                            waitingDialog.show('Loading...',{

                                // if the option is set to boolean false, it will hide the header and "message" will be set in a paragraph above the progress bar.
                                // When headerText is a not-empty string, "message" becomes a content above the progress bar and headerText string will be set as a text inside the H3;
                                headerText: `${list_lang_install[current_task]}`,

                                // this will generate a heading corresponding to the size number
                                headerSize: 3,

                                // extra class(es) for the header tag
                                headerClass: '',

                                // bootstrap postfix for dialog size, e.g. "sm", "m"
                                dialogSize: 'm',
                                width:"100%",

                                // bootstrap postfix for progress bar type, e.g. "success", "warning";
                                progressType: '',

                                // determines the tag of the content element
                                contentElement: 'p',

                                // extra class(es) for the content tag
                                contentClass: 'content'

                            });

                        },
                        success: function (response) {
                            waitingDialog.hide();
                            response = JSON.parse(response);
                            let data_response = response.data;
                            data_response = JSON.parse(data_response);
                            if (data_response.result === "success") {
                                plugin.setup_follow_tool();
                            } else {
                                $.confirm({
                                    title: 'Error!',
                                    content: data_response.msg,
                                    buttons: {
                                        Done: function () {
                                            window.location.href = `${wpbookingpro_root_url}/wp-admin/plugins.php`;
                                        }
                                    }
                                });
                            }
                        },
                        error: function (xhr) {
                            $.alert({
                                title: 'Error',
                                content: 'there are some error please contact admin !',
                            });
                        },
                        complete: function (response) {
                        },
                    });

                }
            } else {
                waitingDialog.hide();
                $.confirm({
                    title: 'Success!',
                    content: 'Completed setup !',
                    buttons: {
                        Done: function () {
                            window.location.href = wpbookingpro_root_url+"/wp-admin/admin.php?page=wb_dashboard";
                        }
                    }
                });
            }
        };
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            plugin.settings.all_tool_check= JSON.parse(JSON.stringify(plugin.settings.tool_check));

            $element.find('.btn-next').on('click',function (e) {
                let atLeastOneIsChecked = $element.find('input.tool-item:checkbox:checked').length > 0;
                if (!atLeastOneIsChecked) {
                    $.alert({
                        title: 'Error',
                        content: 'you must less one checked',
                    });
                    return false;
                }
                $.confirm({
                    title: 'Confirm',
                    content: 'Are you sure do this action ?',
                    buttons: {
                        confirm: function () {
                            $element.find('form[name="admin-form"]').trigger('submit');
                        },
                        cancel: function () {
                        }
                    }
                });
                return true;
            });
            $element.find('.list-tool input.tool-item').iCheck({
                checkboxClass: 'icheckbox_square-red',
                radioClass: 'iradio_square-red',
                increaseArea: '20%'
            });
            let step = plugin.settings.step;
            if (step === 2) {
                plugin.setup_follow_tool();
            }
            $element.find('.list-tool label').on('hover',function (e) {
                let $self = $(this);
                let $li = $self.closest('li');
                let $description_content = $li.find('div.description-content');
                let tooltip = "";
                if ($description_content.length > 0) {
                    tooltip = $description_content.html().trim();
                } else {
                    tooltip = $self.attr('title');
                    if (tooltip.trim() === "") {
                        tooltip = $self.text();
                    }
                }
                $element.find('.description').html(tooltip);
            });
        }
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.view_config_install = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_config_install')) {
                let plugin = new $.view_config_install(this, options);
                $(this).data('view_config_install', plugin);
            }
        });
    }
})(jQuery);

