<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdmin\app\helpers\AdminHelper;
use WpBookingProAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingProHtmlBackendAlias::load_jquery_library('icheck');
WpBookingProHtmlBackendAlias::load_jquery_library('datatables');

$item = $this->item;
$check_user_demo = AdminHelper::checkUserDemo();
$uploads = wp_upload_dir();

$check_image_size = AdminHelper::checkImageData($uploads['baseurl'], $item->image);

?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("category.form")) ?>" name="admin-form" method="post">
        <div class="view-list-category">
            <table id="vendor-category" class="display table">
                <thead>
                    <tr>
                        <th class="nowrap"></th>
                        <th class="view-list-category-th nowrap"><?php esc_html_e('Name','wpbookingpro')?></th>
                        <th class="view-list-category-th nowrap"><?php esc_html_e('Image','wpbookingpro')?></th>
                        <th class="view-list-category-th nowrap"><?php esc_html_e('Published','wpbookingpro')?></th>
                        <th class="view-list-category-th nowrap"><?php esc_html_e('Vendor','wpbookingpro')?></th>
                        <th class="view-list-category-th nowrap"><?php esc_html_e('Id','wpbookingpro')?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($item->list_category as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="name nowrap"><?php echo (esc_html($item->name)); ?></td>
                        <td class="image nowrap">
                            <div class="img-box">
                                <div>
                                    <?php if($check_user_demo['is_demo']) {?>
                                        <?php if($check_image_size) {?>
                                            <img class="category-image" src="<?php echo (esc_attr($uploads['baseurl'].'/'.$item->image)); ?>" alt="category-image"/>
                                        <?php } else {?>
                                            <img class="category-image" src="<?php echo (esc_attr(FactoryAlias::getRootUrlPlugin().$item->image)); ?>" alt="category-image"/>
                                        <?php } ?>

                                    <?php } else {?>
                                        <img class="category-image" src="<?php echo (esc_attr(FactoryAlias::getRootUrlPlugin().$item->image)); ?>" alt="category-image"/>
                                    <?php } ?>
                                </div>
                            </div>
                        </td>
                        <td class="nowrap">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square" title="<?php esc_attr_e('Public','wpbookingpro');?>"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle" title="<?php esc_attr_e('Not published','wpbookingpro');?>"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="nowrap">
                            <?php echo (esc_html(isset($item->vendor)?UtilityAlias::get_full_name($item->vendor->first_name, $item->vendor->last_name):'None'))?>
                        </td>
                        <td class="id nowrap"><?php echo (esc_html($item->id)); ?></td>
                        <td class="state-action">
                            <a href="<?php echo($this->permission?UtilityAlias::getBackendGoToLink("category.form",array('id'=>$item->id)):'javascript:void(0);') ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>><i class="fas fa-edit"></i></a>
                            <a href="<?php echo($this->permission?UtilityAlias::goToTaskByView("category","category.delete",array('id'=>$item->id)):'javascript:void(0);') ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?> ><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
