<?php

namespace WpBookingProAdmin\app\views\vendor;

use WpBookingPro\Html\ToolBar;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\View\View;
use WpBookingPro\Factory as FactoryAlias;
use WpBookingProAdmin\app\helpers\AdminHelper;

class VendorView extends View
{
    public function display($tpl)
    {
        $modelvendor = Model::getInstance("vendor");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::delete("user.delete");
                $model = Model::getInstance("vendors");
                $this->list = $model->getListVendor();
                $this->permission = AdminHelper::setPermission();
                break;
            case "form":
                ToolBar::setTitle('Detail vendor');
                ToolBar::cancel("vendor.cancel");
                ToolBar::back_to_list("vendor.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelvendor->getInfoVendor($id);
                $this->form = $modelvendor->getForm();
                $this->permission = AdminHelper::setPermission();
                break;
        }
        return parent::display($tpl);
    }
}