<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdmin\app\helpers\AdminHelper;
use WpBookingProAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingProHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List user");
WpBookingProHtmlBackendAlias::load_jquery_library('datatables');
WpBookingProHtmlBackendAlias::load_jquery_library('select2');
WpBookingProHtmlBackendAlias::load_jquery_library('loading_js');

$list_role = AdminHelper::get_editable_roles();

?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("user.form")) ?>" name="admin-form" method="post">
        <div class="view-list-user">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th class="nowrap"></th>
                        <th class="view-list-user-th nowrap"><?php esc_html_e('User name','wpbookingpro')?></th>
                        <th class="view-list-user-th nowrap"><?php esc_html_e('Image','wpbookingpro')?></th>
                        <th class="view-list-user-th nowrap"><?php esc_html_e('Group','wpbookingpro')?></th>
                        <th class="view-list-user-th nowrap"><?php esc_html_e('Phone','wpbookingpro')?></th>
                        <th class="view-list-user-th nowrap"><?php esc_html_e('Birthday','wpbookingpro')?></th>
                        <th class="view-list-user-th nowrap"><?php esc_html_e('Set role WP','wpbookingpro')?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr data-user_wp_id="<?php echo (esc_attr($item->user_wordpress->ID))?>">
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="name nowrap"><?php echo (esc_html(UtilityAlias::get_full_name($item->first_name, $item->last_name))); ?></td>
                        <td class="image nowrap">
                            <div class="img-box">
                                <div>
                                    <img class="user-image" src="<?php echo (esc_url($item->image)); ?>" alt="user-image"/>
                                </div>
                            </div>
                        </td>
                        <td class="nowrap">
                            <?php echo (esc_html($item->group_name)); ?>
                        </td>
                        <td class="nowrap">
                            <?php
                            $mobile = isset($item->mobile)?$item->mobile:'';
                            if($mobile['0'] == 0) {
                                $mobile = substr($mobile,1);
                            }
                            $phonecode = isset($item->phonecode)?$item->phonecode:'';
                            echo (esc_html('+'.$phonecode . $mobile));
                            ?>
                        </td>
                        <td class="id nowrap"><?php echo (esc_html($item->birthday)); ?></td>
                        <td class="id nowrap">
                            <select class="form-control list-role" <?php echo (esc_attr($this->permission? '':'disabled'))?> >
                                <option value=""> <?php esc_html_e('Select role','wpbookingpro') ?></option>
                                <?php foreach ($list_role as $key => $role) { ?>
                                    <option <?php echo ($key == $item->user_wordpress->roles[0] ? " selected " : "") ?>
                                            value="<?php echo (esc_attr($key)); ?>"><?php echo (esc_html(ucfirst($key))); ?></option>
                                <?php } ?>
                            </select>
                        </td>
                        <td class="state-action">
                            <a href="<?php echo($this->permission?UtilityAlias::getBackendGoToLink("user.form",array('id'=>$item->id)):'javascript:void(0)') ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>><i class="fas fa-edit"></i></a>
                            <a href="<?php echo($this->permission?UtilityAlias::goToTaskByView("user","user.delete",array('id'=>$item->id)):'javascript:void(0)') ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin/app/assets/less/view_list_user.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-user', 'view_list_user', array(

), "admin/app/assets/js/view_list_user.js");
?>