<?php

namespace WpBookingProAdmin\app\views\states;

use WpBookingPro\Html\ToolBar;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\View\View;
use WpBookingPro\Factory as FactoryAlias;
use WpBookingProAdmin\app\helpers\AdminHelper;

class StatesView extends View
{
    public function display($tpl)
    {
        $modelState = Model::getInstance("state");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("state.add");
                ToolBar::delete("state.delete_list");
                ToolBar::_clone("state.clone_list");
                $model = Model::getInstance("states");
                $this->list = $model->getList();
                $modelVendors = Model::getInstance('vendors');
                $this->list_vendor = $modelVendors->getListVendor();
                $this->permission = AdminHelper::setPermission();
                break;
            case "form":
                ToolBar::setTitle('Edit state');
                ToolBar::apply("state.apply");
                ToolBar::save("state.save");
                ToolBar::cancel("state.cancel");
                ToolBar::back_to_list("state.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelState->getItem($id);
                $this->form = $modelState->getForm();
                break;
        }
        return parent::display($tpl);
    }
}