<?php

use WpBookingPro\Factory;
use WpBookingPro\Html\WpBookingProHtmlBackend;
use WpBookingPro\Language\Text;
use WpBookingProAdmin\app\HtmlCustomField\HtmlCustomFieldBackend;
WpBookingProHtmlBackend::load_jquery_library('loading_js');
$config=Factory::getAppConfig();
$booking_style=$config->get('booking_style',"in_line");
$doc = Factory::getDocument();
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
?>
<div class="view-service-form">
    <form action="" method="post" name="admin-form" enctype="multipart/form-data">

        <div>
            <ul class="state-tab nav nav-tabs" role="tablist">
                <li role="presentation" class="active">
                    <a href="#home" aria-controls="home" role="tab" data-toggle="tab">
                        <?php esc_html_e('Service detail','wpbookingpro') ?>
                    </a>
                </li>
                <li role="presentation">
                    <a href="#profile" aria-controls="profile" role="tab" data-toggle="tab">
                        <?php esc_html_e('Gallery','wpbookingpro') ?>
                    </a>
                </li>
                <li role="presentation">
                    <a href="#settings" aria-controls="settings" role="tab" data-toggle="tab">
                        <?php esc_html_e('Settings','wpbookingpro') ?>
                    </a>
                </li>
                <li role="presentation">
                    <a href="#customize" aria-controls="customize" role="tab" data-toggle="tab">
                        <?php esc_html_e('Customize','wpbookingpro') ?>
                    </a>
                </li>
            </ul>
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="home">
                    <div class="row">
                        <div class="col-md-12">
                            <?php
                            $field=$this->form->getField('image');
                            ?>
                            <?php echo($field->input) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('name')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('user_id')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('category_id')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('location_id')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('alias')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('meta_keyword')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('meta_description')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('duration')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('price')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('open_time')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('close_time')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('working_day')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('mobile')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('facebook','params')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('instagram','params')) ?>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('buffer_time_before')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('buffer_time_after')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo($this->form->renderField('deposit_percent')) ?>
                        </div>
                        <div class="col-md-3">
                            <?php echo($this->form->renderField('minimum_capacity')) ?>
                        </div>
                        <div class="col-md-3">
                            <?php echo($this->form->renderField('maximum_capacity')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('list_employee_id')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('price_will_multiply')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <?php $field = $this->form->getField('bringing_anyone'); ?>
                        <div class="col-md-12">
                            <?php echo($field->input) ?>
                        </div>
                    </div>
                    <div class="row">
                        <?php $field = $this->form->getField('multiply_number'); ?>
                        <div class="col-md-12">
                            <?php echo($field->input) ?>
                        </div>
                    </div>
                    <div class="row">
                        <?php $field = $this->form->getField('published'); ?>
                        <div class="col-md-12">
                            <?php echo($field->input) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('description')) ?>
                        </div>
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane" id="profile">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('gallery')) ?>
                        </div>
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane" id="settings">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('disable_payment_online')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo($this->form->renderField('service_color')) ?>
                        </div>
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane" id="customize">
                    <?php
                    foreach ($this->list_customize as $customize) {
                        echo (HtmlCustomFieldBackend::render_by_type($customize));
                    }

                    ?>
                </div>
            </div>
        </div>
		<?php echo ($this->form->renderField('id')) ?>
        <input type="hidden" name="task" value="state.save">
    </form>
</div>
<?php
$doc->addScriptApplySelector('.view-service-form','view_form_service', array(

),'admin/app/assets/js/view_form_service.js');
