<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdmin\app\helpers\AdminHelper;
use WpBookingProAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingProHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List payment");
WpBookingProHtmlBackendAlias::load_jquery_library('datatables');

$check_user_demo = AdminHelper::checkUserDemo();
$uploads = wp_upload_dir();
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("payment.form")) ?>" name="admin-form" method="post">
        <div class="view-list-payment">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_html_e('Index','wpbookingpro'); ?></th>
                        <th class="view-list-payment-th nowrap"><?php esc_html_e('Name','wpbookingpro') ?></th>
                        <th class="view-list-payment-th nowrap"><?php esc_html_e('Image','wpbookingpro') ?></th>
                        <th class="view-list-payment-th nowrap"><?php esc_html_e('Payment type','wpbookingpro') ?></th>
                        <th class="view-list-payment-th nowrap"><?php esc_html_e('ID','wpbookingpro') ?></th>
                        <th class="view-list-payment-th nowrap"><?php esc_html_e('Status','wpbookingpro') ?></th>
                        <th class="nowrap"></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="name nowrap"><?php echo (esc_html($item->name)) ?></td>
                        <td class="image nowrap">
                            <div class="img-box">
                                <?php $check_image_size = AdminHelper::checkImageData($uploads['baseurl'], $item->image)?>
                                <?php if($check_user_demo['is_demo']) {?>
                                    <?php if($check_image_size) {?>
                                        <img class="payment-image" src="<?php echo (esc_attr($uploads['baseurl'].'/'.$item->image)) ?>" alt="payment-image" />
                                    <?php } else {?>
                                        <img class="payment-image" src="<?php echo (esc_attr(FactoryAlias::getRootUrlPlugin().$item->image)) ?>" alt="payment-image" />
                                    <?php }?>

                                <?php } else {?>
                                    <img class="payment-image" src="<?php echo (esc_attr(FactoryAlias::getRootUrlPlugin(). $item->image)) ?>" alt="payment-image" />
                                <?php } ?>
                            </div>
                        </td>
                        <td class="name nowrap"><?php echo (esc_html($item->type)) ?></td>
                        <td class="id nowrap"><?php echo (esc_html($item->id)) ?></td>
                        <td class="nowrap">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square" title="<?php esc_attr_e('Public','wpbookingpro') ?> "></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle" title="<?php esc_attr_e('Not public','wpbookingpro') ?> "></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="payment-action">
                            <a href="<?php echo($this->permission?UtilityAlias::getBackendGoToLink("payment.form",array('id'=>$item->id)):'javascript:void(0)') ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>><i class="fas fa-edit"></i></a>
                            <a href="<?php echo($this->permission?UtilityAlias::goToTaskByView("payment","payment.delete",array('id'=>$item->id)):'javascript:void(0)') ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin/app/assets/less/view_list_payment.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-payment', 'view_list_payment', array(

), "admin/app/assets/js/view_list_payment.js");
?>