<?php

use WpBookingProAdmin\app\Html\HtmlBackend;
use WpBookingPro\Utilities\Utility as UtilityAlias;

$item = $this->item;
?>
<tr data-id="<?php echo (esc_attr($item->id)) ?>">
    <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
    <td class="name nowrap"><?php echo (esc_html($item->name)); ?></td>
    <td class="event-item nowrap">
        <?php if (count((array)$item->list_event)) { ?>
            <?php foreach ((array)$item->list_event as $event) { ?>
                <span class="label label-info"><?php echo (esc_html($event->name)) ?></span>
            <?php } ?>
        <?php } ?>
    </td>
    <td class="nowrap">
        <?php if ($item->published == 1) { ?>
            <div class="published">
                <i class="fas fa-check-square" title="<?php esc_attr_e('Public','wpbookingpro')?>"></i>
            </div>
        <?php } else { ?>
            <div class="unpublished">
                <i class="far fa-times-circle" title="<?php esc_attr_e('Not Public','wpbookingpro')?>"></i>
            </div>
        <?php } ?>
    </td>
    <td>
        <a href="<?php echo(UtilityAlias::getBackendGoToLink("package.form",array("id"=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>"><i class="fas fa-edit"></i></a>
        <a href="<?php echo(UtilityAlias::goToTaskByView("package",'package.delete',array("id"=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>"><i class="fas fa-trash-alt"></i></a>
    </td>
</tr>
