<?php

namespace WpBookingProAdmin\app\views\package;

use WpBookingPro\Html\ToolBar;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\View\View;
use WpBookingPro\Factory as FactoryAlias;

class PackageView extends View
{
    public function display($tpl)
    {
        $modelPackage = Model::getInstance("package");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("package.add");
                ToolBar::delete("package.delete_list");
                ToolBar::_clone("package.clone_list");
                $model = Model::getInstance("packages");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit package');
                ToolBar::apply("package.apply");
                ToolBar::save("package.save");
                ToolBar::cancel("package.cancel");
                ToolBar::back_to_list("package.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelPackage->getItem($id);
                $this->form = $modelPackage->getForm();
                break;
        }
        return parent::display($tpl);
    }
}