<?php

namespace WpBookingProAdmin\app\views\groupuser;

use WpBookingPro\Html\ToolBar;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\View\View;
use WpBookingPro\Factory as FactoryAlias;
use WpBookingProAdmin\app\helpers\AdminHelper;

class GroupuserView extends View
{
    public function display($tpl)
    {
        $modelgroupuser = Model::getInstance("groupuser");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("groupuser.add");
                ToolBar::delete("groupuser.delete_list");
                ToolBar::_clone("groupuser.clone_list");
                $model = Model::getInstance("groupuser");
                $this->list = $model->getList();
                $this->permission = AdminHelper::setPermission();
                break;
            case "form":
                ToolBar::setTitle('Edit groupuser');
                ToolBar::apply("groupuser.apply");
                ToolBar::save("groupuser.save");
                ToolBar::cancel("groupuser.cancel");
                ToolBar::back_to_list("groupuser.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelgroupuser->getItem($id);
                $this->form = $modelgroupuser->getForm();
                break;
        }
        return parent::display($tpl);
    }
}