<?php

use WpBookingProAdmin\app\Html\HtmlBackend;
use WpBookingPro\Utilities\Utility as UtilityAlias;

$item = $this->item;
?>
<tr data-id="<?php echo (esc_attr($item->id)) ?>" class="list-rate-title">
    <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
    <td class="name nowrap"><?php echo (esc_html($item->name)) ?></td>
    <td class="name nowrap"><?php echo (esc_html($item->total_order)) ?></td>
    <td class="nowrap"><?php echo (esc_html($item->total_person)) ?>/<?php echo (esc_html($item->max_allowed_person)) ?></td>
    <td class="nowrap"><?php echo (esc_html($item->min_allowed_person)) ?>-<?php echo (esc_html($item->max_allowed_person)) ?></td>
    <td class="recurring">
        <?php if(isset($item->recurring)) {?>
            <i class="fas fa-sync-alt"></i> <span><?php esc_html_e('Yes','wpbookingpro')?></span>
        <?php } else {?>
            <i class="fas fa-sync-alt"></i> <span><?php esc_html_e('No','wpbookingpro')?></span>
        <?php }?>
    </td>
    <td class="open_date nowrap"><?php echo(HtmlBackend::render_date(isset($item->open_date)?$item->open_date:"","Y-m-d")); ?></td>
    <td class="close_date nowrap"><?php echo(HtmlBackend::render_date(isset($item->close_date)?$item->close_date:"","Y-m-d")); ?></td>
    <td class="published">
        <?php if(isset($item->published)) {?>
            <span class="label label-success"><?php esc_html_e('Open','wpbookingpro')?></span>
        <?php } else {?>
            <span class="label label-danger"><?php esc_html_e('Close','wpbookingpro')?></span>
        <?php }?>
    </td>
    <td class="item-id nowrap"><?php echo (esc_html($item->id)) ?></td>
    <td>
        <a href="<?php echo(UtilityAlias::getBackendGoToLink("event.form",array("id"=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>"><i class="fas fa-edit"></i></a>
        <a href="<?php echo(UtilityAlias::goToTaskByView("event",'event.delete',array("id"=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>"><i class="fas fa-trash-alt"></i></a>
    </td>
</tr>
