<?php

namespace WpBookingProAdmin\app\views\event;

use WpBookingPro\Html\ToolBar;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\View\View;
use WpBookingPro\Factory as FactoryAlias;

class EventView extends View
{
    public function display($tpl)
    {
        $modelEvent = Model::getInstance("event");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("event.add");
                ToolBar::delete("event.delete_list");
                ToolBar::_clone("event.clone_list");
                $model = Model::getInstance("events");
                $this->list = $model->getList();
                break;
            case "form":
                ToolBar::setTitle('Edit Event');
                ToolBar::apply("event.apply");
                ToolBar::save("event.save");
                ToolBar::cancel("event.cancel");
                ToolBar::back_to_list("event.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelEvent->getItem($id);
                $this->form = $modelEvent->getForm();
                break;
        }
        return parent::display($tpl);
    }
}