<?php

use WpBookingPro\Factory;
use WpBookingProAdmin\app\helpers\AdminHelper;
use WpBookingProAdmin\app\Html\HtmlBackend;
use WpBookingPro\Utilities\Utility as UtilityAlias;

$item = $this->item;

$check_user_demo = AdminHelper::checkUserDemo();
$uploads = wp_upload_dir();
$check_image_size = AdminHelper::checkImageData($uploads['baseurl'], $item->cover);


?>
<div class="wrapper-employee-item" data-employee_id="<?php echo (esc_attr($item->id)); ?>">
    <?php echo (HtmlBackend::render_checkbox($item->id)) ?>
    <div class="wrapper-employee-content">
        <div class="employee-item-image pull-left">
            <div>
                <?php if($check_user_demo['is_demo']) { ?>
                    <?php if($check_image_size) { ?>
                        <img class="image-cover" src="<?php echo (esc_url($item->cover == null ? Factory::getRootUrlPlugin(). 'admin/app/assets/images/no-image.jpg' : $uploads['baseurl'].'/'.$item->cover)) ?>" alt="employee-item-image" />
                    <?php } else {?>
                        <img class="image-cover" src="<?php echo (esc_url($item->cover == null ? Factory::getRootUrlPlugin(). 'admin/app/assets/images/no-image.jpg' : Factory::getRootUrlPlugin().$item->cover)) ?>" alt="employee-item-image" />
                    <?php } ?>
                <?php } else {?>
                    <img class="image-cover" src="<?php echo (esc_url($item->cover == null ? Factory::getRootUrlPlugin().'admin/app/assets/images/no-image.jpg' : Factory::getRootUrlPlugin().$item->cover)) ?>" alt="employee-item-image" />
                <?php } ?>
            </div>
        </div>
        <div class="employee-item-content pull-left">
            <p><label class="name"><?php echo (esc_html(ucwords($item->full_name))) ?></label></p>
            <p><label class="email"><?php echo (esc_html($item->email)); ?></label></p>
            <p>
                <label class="mobile">
                    <?php
                    $mobile = isset($item->mobile)?$item->mobile:'';
                    if(trim($mobile)!= '' && $mobile['0'] == 0) {
                        $mobile = substr($mobile,1);
                    }
                    $phonecode = isset($item->phonecode)?$item->phonecode:'';
                    echo (esc_html('+'.$phonecode . $mobile));
                    ?>
                </label>
            </p>
        </div>
    </div>
    <div class="employee-action">
        <?php if ($item->published == 1) { ?>
            <div class="away">
                <p><?php esc_attr_e('Away','wpbookingpro') ?></p>
            </div>
        <?php } else { ?>
            <div class="away">
                <p><?php esc_attr_e('Offline','wpbookingpro') ?></p>
            </div>
        <?php } ?>
        <a class="btn btn-primary btn-edit" href="<?php echo($this->permission?UtilityAlias::getBackendGoToLink("employee.form",array("id"=>$item->id)):'javascript:void(0)') ?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>>
            <i class="fas fa-edit"></i>
            <?php esc_html_e('Edit','wpbookingpro')?>
        </a>
    </div>
</div>
