<?php

use WpBookingPro\Factory;
use WpBookingPro\Html\WpBookingProHtmlBackend;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Language\Text;
use WpBookingProAdmin\app\Html\HtmlBackend;

$doc = Factory::getDocument();
WpBookingProHtmlBackend::load_jquery_library('chart_js');
WpBookingProHtmlBackend::load_jquery_library('bootstrap_tabs');
WpBookingProHtmlBackend::load_jquery_library('datatables');
$doc->addLessStyleSheet('admin/app/assets/less/view_db_appointments_dashboard.less');
$number_user= count((array)$this->list_customer);
$number_month=count((array)$this->list_order_by_month);
$number_month_order=count((array)$this->list_order_by_month,1);
$number_oder= $number_month_order - $number_month;
$number_categories= count((array)$this->list_categories);
$total=0;
?>
    <div class="view-db-appointments-dashboard">
        <div class="logo-appointment">
            <img src="<?php echo(Factory::getRootUrlPlugin())?>admin/app/assets/images/Logo WPAppointment.svg" alt="logo">
        </div>
        <div class="row">
            <div class="col-md-3">
                <div class="block-item-widget user">
                    <div class="icon-block">
                        <i class="fas fa-user-friends"></i>
                    </div>
                    <div class="content-block">
                        <h4> <?php esc_html_e('New users','wpbookingpro') ?></h4>
                        <p><?php echo ($number_user?$number_user:0); ?> <?php esc_html_e('New users','wpbookingpro') ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="block-item-widget order">
                    <div class="icon-block">
                        <i class="fas fa-cart-plus"></i>
                    </div>
                    <div class="content-block">
                        <h4><?php esc_html_e('New orders','wpbookingpro') ?></h4>
                        <p><?php echo (esc_html($number_oder));  ?> <?php esc_html_e('new orders','wpbookingpro') ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="block-item-widget delivery">
                    <div class="icon-block">
                        <i class="fas fa-shopping-bag"></i>
                    </div>
                    <div class="content-block">
                        <h4><?php esc_html_e('Categories','wpbookingpro') ?></h4>
                        <p><?php echo (esc_html($number_categories));  ?> <?php esc_html_e('Categories','wpbookingpro') ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="block-item-widget monthly">
                    <div class="icon-block">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                    <div class="content-block">
                        <?php foreach ($this->list_order_in_year as $item) { ?>
                            <?php $total += $item->total ?>
                        <?php } ?>
                        <h4><?php esc_html_e('Yearly profits','wpbookingpro') ?></h4>
                        <p><?php echo (esc_html(HtmlBackend::render_price($total))); ?> <?php esc_html_e('This year','wpbookingpro') ?></p>
                    </div>
                </div>
            </div>

        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="total-order">
                    <h3><?php esc_html_e('Total order','wpbookingpro') ?></h3>
                    <canvas class="order-this-week"></canvas>
                </div>
            </div>
            <div class="col-md-6">
                <div class="monthly-profits">
                    <h3><?php esc_html_e('Month profits','wpbookingpro') ?></h3>
                    <canvas class="employee-chart"></canvas>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="new-customer">
                    <h3><?php esc_html_e('New customer','wpbookingpro') ?></h3>
                    <table class="table table-responsive table-customer">
                        <thead>
                        <tr>
                            <th class="nowrap"><?php esc_html_e('Id','wpbookingpro') ?></th>
                            <th class="nowrap"><?php esc_html_e('Name','wpbookingpro') ?></th>
                            <th class="nowrap"><?php esc_html_e('Phone','wpbookingpro') ?></th>
                            <th class="nowrap"><?php esc_html_e('Order time','wpbookingpro') ?> </th>
                        </tr>
                        </thead>
                        <tbody class="list-wbcustomer main-table">
                        <?php foreach ($this->list_customer as $item) { ?>
                            <?php $this->item = $item ?>
                            <?php $this->loadTemplate('list_item_customer') ?>
                        <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="col-md-6">
                <div class="list-category">
                    <h3><?php esc_html_e('List Categories','wpbookingpro') ?></h3>
                    <table class="table table-responsive table-category">
                        <thead>
                        <tr>
                            <th class="view-list-category-th nowrap"><?php esc_html_e('Id','wpbookingpro') ?></th>
                            <th class="view-list-category-th nowrap"><?php esc_html_e('Name','wpbookingpro') ?></th>
                            <th class="view-list-category-th nowrap"><?php esc_html_e('Image','wpbookingpro') ?></th>
                        </tr>
                        </thead>
                        <tbody class="list-category main-table">
                        <?php foreach ($this->list_categories as $item) { ?>
                            <?php $this->item = $item ?>
                            <?php $this->loadTemplate('list_item_category') ?>
                        <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php
$doc->addScriptApplySelector('.view-db-appointments-dashboard','view_db_appointments_dashboard',array(
    "list_order_by_month"=>$this->list_order_by_month
),'admin/app/assets/js/view_db_appointments_dashboard.js');