<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
use WpBookingPro\Language\Text;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingProAdmin\app\Html\HtmlBackend;
$doc = FactoryAlias::getDocument();
$doc->addLessStyleSheet('admin/app/assets/less/view_list_customers.less');
WpBookingProHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List Customer");
WpBookingProHtmlBackendAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("customers.form")) ?>" name="admin-form" method="post">
        <div class="view-list-customers">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_html_e('Index','wpbookingpro'); ?></th>
                        <th><?php esc_html_e('Customer name','wpbookingpro'); ?></th>
                        <th><?php esc_html_e('Phone','wpbookingpro'); ?></th>
                        <th><?php esc_html_e('Birthday','wpbookingpro'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id))?></td>
                        <td class="customer-name"><?php echo (esc_html($item->first_name)); ?> <?php echo (esc_html($item->last_name)); ?></td>
                        <td class="customer-phone"><?php echo (esc_html($item->mobile)); ?></td>
                        <td class="customer-birthday"><?php echo (esc_html($item->birth_day)); ?></td>
                        <td class="customer-action">
                            <a href="<?php echo($this->permission?UtilityAlias::getBackendGoToLink("customers.form",array('id'=>$item->id)):'javascript:void(0)') ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>><i class="fas fa-edit"></i> </a>
                            <a href="<?php echo($this->permission?UtilityAlias::goToTaskByView("customers","customer.delete",array('id'=>$item->id)):'javascript:void(0);') ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="customer.save">
    </form>
<?php
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-customers', 'view_list_customers', array(), "admin/app/assets/js/view_list_customers.js");
?>