<?php

use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
$doc = Factory::getDocument();
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
?>
<div class="view-coupon-form">
    <form action="" name="admin-form" method="post" enctype="multipart/form-data">
        <div>
            <ul class="coupon-tab nav nav-tabs" role="tablist">
                <li role="presentation" class="active"><a href="#detail" aria-controls="detail" role="tab"
                                                          data-toggle="tab"><?php esc_attr_e('Detail coupon','touroperatorpro'); ?> </a></li>
            </ul>
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="detail">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo ($this->form->renderField('name')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo ($this->form->renderField('code')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo ($this->form->renderField('service_id')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo ($this->form->renderField('user_id')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?php echo ($this->form->renderField('amount')) ?>
                        </div>
                        <div class="col-md-6">
                            <?php echo ($this->form->renderField('percent')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php
                            $field = $this->form->getField('published');
                            ?>
                            <?php echo ($field->input) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo ($this->form->renderField('description')) ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php echo ($this->form->renderField('id')) ?>
        <input type="hidden" name="task" value="coupon.save">
    </form>
</div>
<?php
$doc->addScriptApplySelector('.view-coupon-form', 'view_form_coupon', array(

), 'admin/app/assets/js/view_form_coupon.js');
