<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingProHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List countries");
WpBookingProHtmlBackendAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendGoToLink("countries.form")) ?>" name="admin-form" method="post">
        <div class="view-list-countries">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_html_e('Index','wpbookingpro'); ?></th>
                        <th><?php esc_html_e('Country name','wpbookingpro'); ?></th>
                        <th><?php esc_html_e('Country code','wpbookingpro'); ?></th>
                        <th><?php esc_html_e('Flag','wpbookingpro'); ?></th>
                        <th><?php esc_html_e('Publish','wpbookingpro'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="country-name">
                            <h4>
                                <?php echo ($item->countryname); ?>
                            </h4>
                        </td>
                        <td class="country-code"><?php  echo (esc_html($item->countrycode)); ?> </td>
                        <td class="country-flag">
                            <img src="<?php  echo (esc_attr(FactoryAlias::getRootUrlPlugin().'/'.$item->image)) ?>" alt="flag">
                        </td>
                        <td class="country-published">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square" title="<?php esc_attr_e('Public','wpbookingpro');?>"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle" title="<?php esc_attr_e('Not Public','wpbookingpro');?>"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="country-action">
                            <a href="<?php echo($this->permission?UtilityAlias::getBackendGoToLink("countries.form",array('id'=>$item->id)):'javascript:void(0);') ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>><i class="fas fa-edit"></i></a>
                            <a href="<?php echo($this->permission?UtilityAlias::goToTaskByView("countries","country.delete",array('id'=>$item->id)):'javascript:void(0)') ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin/app/assets/less/view_list_countries.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-countries', 'view_list_countries', array(

), "admin/app/assets/js/view_list_countries.js");
?>