<?php

namespace WpBookingProAdmin\app\views\countries;

use WpBookingPro\Html\ToolBar;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\View\View;
use WpBookingPro\Factory as FactoryAlias;
use WpBookingProAdmin\app\helpers\AdminHelper;

class CountriesView extends View
{
    public function display($tpl)
    {
        $modelCountry = Model::getInstance("country");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("country.add");
                ToolBar::delete("country.delete_list");
                ToolBar::_clone("country.clone_list");
                $model = Model::getInstance("countries");
                $this->list = $model->getList();
                $this->permission = AdminHelper::setPermission();
                break;
            case "form":
                ToolBar::setTitle('Edit Country');
                ToolBar::save("country.save");
                ToolBar::cancel("country.cancel");
                ToolBar::apply("country.apply");
                ToolBar::back_to_list("country.back_tour_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelCountry->getItem($id);
                $this->form = $modelCountry->getForm();

                break;
        }
        return parent::display($tpl);
    }
}