<?php

use WpBookingPro\Factory;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Language\Text;
WpBookingProHtmlBackendAlias::load_jquery_library('icheck');
WpBookingProHtmlBackendAlias::load_jquery_library('confirm');

WpBookingProHtmlBackendAlias::load_jquery_library('loading_js');
WpBookingProHtmlBackendAlias::load_jquery_library('ui_progress_bar');
WpBookingProHtmlBackendAlias::load_jquery_library('waitingfor');
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/assets/less/view_config_install.less');

$input = Factory::getInput();
$toolChecked = $input->get('tool', array(), 'array');
$step = $input->getInt('step', 0);
if ($step == 1) {
    array_unshift($toolChecked, "install_construct");
    array_unshift($toolChecked, "check_required");
    array_push($toolChecked, "finish_install");
}
$step++;
$list_lang_install=array(
       "install_construct"=>wpbookingpro_get_content('Install construct'),
       "check_required"=>wpbookingpro_get_content('Check required'),
       "setup_sample_database"=>wpbookingpro_get_content('Setup sample database'),
       "import_media_sample"=>wpbookingpro_get_content('Import media sample'),
       "finish_install"=>wpbookingpro_get_content('Finish install'),
);
?>
    <div class="view-config-install">
        <div class="row">
            <div class="col-md-3"></div>
            <div class="col-md-6">
                <div class="form-install" title="Form install">
                    <div class="tool-bar">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="pull-right">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="wrapper-main-tool">
                        <h3><?php esc_html_e('Welcome to WP Booking Appoitment Pro','wpbookingpro')?></h3>
                        <form action="<?php echo(Factory::getRootUrl()) ?>/wp-admin/admin.php?page=wb_config&layout=install" name="admin-form" method="post">
                            <h4 class="setup"><?php esc_html_e('Setup','wpbookingpro')?></h4>
                            <div class="wrapper-tool">
                                <ul class="list-tool">
                                    <li>
                                        <label title="<?php esc_html_e('Check required','wpbookingpro')?>">
                                            <input class="tool-item" checked disabled value="" type="checkbox"> <?php esc_html_e('Check required','wpbookingpro')?>
                                        </label>
                                        <div class="description-content">
                                        </div>
                                    </li>
                                    <li>
                                        <label title="<?php esc_attr_e('Install construct database','wpbookingpro')?>">
                                            <input class="tool-item" checked disabled value="" type="checkbox">
                                            <?php esc_html_e('Install construct database','wpbookingpro')?>
                                        </label>
                                    </li>
                                    <li>
                                        <label title="<?php esc_attr_e('Setup sample database','wpbookingpro')?>">
                                            <input class="tool-item" checked <?php echo ($step == 2 ? " disabled " : "") ?>name="tool[]" <?php echo (esc_attr(in_array("setup_sample_database",
                                                $toolChecked) ? ' checked ' : '')) ?> value="setup_sample_database" type="checkbox"> <?php esc_html_e('Setup sample database','wpbookingpro')?>(<span class="recommend"><?php esc_html_e('recommend','wpbookingpro');?></span>)
                                        </label>
                                    </li>
                                    <li>
                                        <label title="<?php esc_attr_e('Import media sample','wpbookingpro')?>">
                                            <input class="tool-item" name="tool[]" <?php echo ($step == 2 ? " disabled " : "") ?> <?php echo (esc_attr(in_array("import_media_sample",
                                                $toolChecked) ? ' checked ' : '')) ?> value="import_media_sample" type="checkbox"> <?php esc_html_e('Import media sample','wpbookingpro')?>(<span class="recommend"><?php esc_html_e('take 3 minutes, optional','wpbookingpro');?></span>)
                                        </label>
                                    </li>
                                </ul>
                                <div class="tool-bar">
                                    <button class="btn btn-primary btn-next"
                                            type="button" <?php echo (esc_attr($step == 2 ? " disabled " : "")) ?>>
                                        <?php esc_html_e('Next','wpbookingpro');?>
                                    </button>
                                </div>
                            </div>
                            <input type="hidden" name="step" value="<?php echo (esc_attr($step)) ?>">
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php



$doc->addScriptApplySelector('.view-config-install','view_config_install',array(
    "step"=>  (int)$step,
    "tool_check"=>  array_reverse($toolChecked),
    "list_lang_install"=>$list_lang_install,
    "user"=> $this->user
),'admin/app/assets/js/view_config_install.js');

