<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingProAdmin\app\Html\HtmlBackend;
use WpBookingPro\Language\Text;
$doc = FactoryAlias::getDocument();
WpBookingProHtmlBackendAlias::load_jquery_library('icheck');
WpBookingProHtmlBackendAlias::load_jquery_library('select2');
WpBookingProHtmlBackendAlias::load_jquery_library('loading_js');
ToolBar::setTitle("List Appointments");
WpBookingProHtmlBackendAlias::load_jquery_library('datatables');

$input = FactoryAlias::getInput();
$user_id = $input->getInt('user_id',0);

?>
<form action="" name="admin-form" method="post">
    <div class="view-list-appointment">
        <div class="row">
            <div class="col-md-3">
                <div class="block-filter">
                    <h5><?php esc_html_e('Filter by vendor','wpbookingpro');?></h5>
                    <select  id="searchByVendor" name="user_id">
                        <option value=''>-- <?php esc_html_e('Select vendor','wpbookingpro');?>--</option>
                        <?php foreach ($this->list_vendor as $vendor_item) {?>
                            <option value="<?php echo (esc_attr($vendor_item->id)) ?>" <?php echo (esc_attr($user_id == $vendor_item->id ? 'selected':''))?> >
                                <?php echo (esc_html(UtilityAlias::get_full_name($vendor_item->first_name, $vendor_item->last_name)))?>
                            </option>
                        <?php }?>
                    </select>
                </div>

            </div>
        </div>
        <div class="wrapper-table-appointment">
            <table id="example" class="display table">
                <thead>
                    <tr class="header table-info">
                        <th></th>
                        <th><?php esc_html_e('Customer','wpbookingpro')?></th>
                        <th><?php esc_html_e('Total','wpbookingpro')?></th>
                        <th><?php esc_html_e('Deposit','wpbookingpro')?></th>
                        <th><?php esc_html_e('Balance','wpbookingpro')?></th>
                        <th><?php esc_html_e('Recurring','wpbookingpro')?></th>
                        <th><?php esc_html_e('Number day','wpbookingpro')?></th>
                        <th><?php esc_html_e('Status','wpbookingpro')?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item) { ?>
                            <tr class="row-item-order" data-order_id="<?php echo (esc_attr($item->id)) ?>">
                                <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                                <td>
                                    <?php
                                    if(is_user_logged_in()) {
                                        echo (esc_html(UtilityAlias::get_full_name($item->customer->first_name, $item->customer->last_name)));
                                    } else {
                                        echo (esc_html($item->customer->customer_full_name));
                                    }

                                    ?>
                                </td>
                                <td><?php echo (esc_html(HtmlBackend::render_price($item->total))); ?></td>
                                <td><?php echo (esc_html(HtmlBackend::render_price($item->deposit_payment))); ?></td>
                                <td><?php echo (esc_html(HtmlBackend::render_price($item->balance_payment))); ?></td>
                                <td>
                                    <?php
                                        if($item->is_recurring == 0) {
                                            esc_html_e('None','wpbookingpro');
                                        } else {
                                            if($item->type_recurring == 'daily') {
                                                esc_html_e('Daily','wpbookingpro');
                                            } else if($item->type_recurring == 'weekly') {
                                                esc_html_e('Weekly','wpbookingpro');
                                            } else if($item->type_recurring == 'monthly') {
                                                esc_html_e('Monthly','wpbookingpro');
                                            }
                                        }
                                    ?>
                                </td>
                                <td>
                                    <?php
                                        if($item->is_recurring == 0) {
                                            echo 1;
                                        } else {
                                            echo (esc_html($item->number_day_recurring));
                                        }
                                    ?>
                                </td>
                                <td class="nowrap">
                                    <div class="list-order-status">
                                        <select class="order-status" <?php echo (esc_attr($this->permission?'':'disabled'))?>>
                                            <?php foreach ($this->list_order_status as $order_status) { ?>
                                                <option <?php echo (esc_attr($order_status->open_source_order_status_id == $item->open_source_order_status_id ? ' selected ' : '')) ?>
                                                    value="<?php echo (esc_attr($order_status->open_source_order_status_id)); ?>"><?php echo (esc_html($order_status->title)); ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </td>
                                <td>
                                    <a href="<?php echo (($this->permission ? UtilityAlias::getBackendGoToLink("appointment.form",array('id'=>$item->id)) : 'javascript:void(0)')) ?>" class="btn btn-primary btn-detail" title="<?php esc_attr_e('Detail','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?> ><?php esc_html_e('Detail','wpbookingpro')?></a>
                                </td>
                            </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</form>
<?php
$doc->addLessStyleSheet('admin/app/assets/less/list_view_appointment.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-appointment', 'list_view_appointment', array(

), "admin/app/assets/js/list_view_appointment.js");
?>