<?php
namespace WpBookingProAdmin\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use Exception;
use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Filesystem\File as FileAlias;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
use WpBookingPro\Utilities\Utility;

class SmsModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "sms";
    /**
     * @var string
     */
    public $table_name = "sms";
    public function save($data = array())
    {
        $query = $this->_db->getQuery(true);

        $item =  parent::save($data); // TODO: Change the autogenerated stub
        if($data['published'] == 1) {
            $query->update($this->getTableName('sms'))
                ->set('published=0')
                ->where('id <>'.(int)$item->id)
            ;
            $this->_db->setQuery($query)->execute();
        }
        if($item->published == 1) {
            $query->clear()
                ->update($this->getTableName('smscontent'). ' AS smscontent')
                ->set('smscontent.sms_suplier_id='.(int)$item->id)
            ;
            $this->_db->setQuery($query)->execute();
        }

        return $item;
    }
    public function getItem($id = 0)
    {
        $sms =  parent::getItem($id); // TODO: Change the autogenerated stub
        $query = $this->_db->getQuery(true);
        if(!empty((array)$sms)) {
            $query->clear()
                ->select('country.countryname')
                ->from($this->getTableName('country').' AS country')
                ->where('country.phonecode='.(int)$sms->phonecode)
                ->where('country.countrycode='.$query->quote($sms->countrycode))
            ;
            $sms->country_name = $this->_db->setQuery($query)->loadResult();
        }
        return $sms;
    }


}
