<?php
namespace WpBookingProAdmin\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use Exception;
use WpBookingPro\Factory;
use WpBookingPro\Filesystem\File as FileAlias;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
use WpBookingPro\Utilities\Utility;
use WpBookingProAdmin\app\helpers\AdminHelper;

class PackageModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "package";
    /**
     * @var string
     */
    public $table_name = "package";
    public function save($data = array())
    {
        $input = Factory::getInput();
        $query = $this->_db->getQuery(true);
        if (!$data) {
            $data = $input->getData()['data'];

        }
        $package =  parent::save($data); // TODO: Change the autogenerated stub
        $tags = !empty($data['tags'])?$data['tags']:array();
        if (count($tags)) {
            $query->clear()
                ->delete($this->getTableName('package_tag'))
                ->where('package_id=' . (int)$package->id);
            $this->_db->setQuery($query)->execute();
            foreach ($tags as $tag) {
                $query->clear()
                    ->insert($this->getTableName('package_tag'))
                    ->set('package_id=' . $package->id)
                    ->set('tag_id=' . $tag);
                $this->_db->setQuery($query)->execute();
            }
        }
        $list_event_id = $data['list_event_id'];
        $query->clear()
            ->delete($this->getTableName('package_event'))
            ->where('package_id=' . (int)$package->id);
        $this->_db->setQuery($query)->execute();
        foreach ($list_event_id as $event_id) {
            $query->clear()
                ->insert($this->getTableName('package_event'))
                ->set('package_id=' . (int)$package->id)
                ->set('event_id=' . (int)$event_id);
            $this->_db->setQuery($query)->execute();
        }
        $image=Factory::getInput()->files->get('image','','raw');
        if(!empty($image['name'])) {
            $name = str_replace(' ', '_',Utility::gen_random_string()) . $image['name'];
            $short_path_image = "upload/package/images/cover/$name";
            $new_file_image_appointment_path = WPBOOKINGPRO_PATH_ROOT . DS . $short_path_image;
            if (!FileAlias::write($new_file_image_appointment_path, FileAlias::read($image['tmp_name']))) {
                throw new Exception(Text::_("can not upload image cover"));
            }
            $package->image = $short_path_image;
            $data = (array)$package;
            $package = parent::save($data);
        }


        return $package;
    }

    public function getItem($id = 0)
    {
        $item = parent::getItem($id); // TODO: Change the autogenerated stub
        if ($item) {
            $db = Factory::getDBO();
            $query = $db->getQuery(true)
                ->select("tag.id")
                ->from($this->getTableName('package_tag') . ' AS package_tag')
                ->leftJoin($this->getTableName('tag') . ' AS tag ON tag.id=package_tag.tag_id')
                ->where('package_tag.package_id=' . (int)$item->id);
            $item->tags = $db->setQuery($query)->loadColumn();
            $query->clear()
                ->select('package_event.event_id')
                ->from($this->getTableName('package_event') . ' AS package_event')
                ->where('package_id=' . (int)$item->id);
            $item->list_event_id = $db->setQuery($query)->loadColumn();
        }
        return $item;
    }

}
