<?php
namespace WpBookingProAdmin\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Filesystem\File as FileAlias;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
use WpBookingProAdmin\app\helpers\AdminHelper;

class OrderpackageModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "order_package";
    /**
     * @var string
     */
    public $table_name = "order_package";

    public function getItem($id = 0)
    {
        $table=$this->getTable();
        $key = $table->getKeyName();
        $input=Factory::getInput();
        if(!$id){
            $id=$input->getInt($key,0);
        }
        $db=Factory::getDBO();
        $query=$db->getQuery(true);
        $query->select("DISTINCT wborder.*")
            ->from($this->getTableName('order').' AS wborder')
            ->leftJoin($this->getTableName('customer') . ' AS customer ON customer.id=wborder.customer_id')
            ->select('customer.first_name as customer_first_name,customer.last_name as customer_last_name,customer.image as customer_image')
            ->where('wborder.type='.$query->quote(AdminHelper::getWpBookingPackageKey()))
        ;
        $item=$this->db->setQuery($query)->loadObject();
        $query->clear()
            ->select("order_package.*")
            ->from($this->getTableName('order_package') . ' AS order_package')
            ->leftJoin($this->getTableName('employee') . ' AS employee  ON employee.id=order_package.employee_id')
            ->select('employee.first_name AS employee_first_name,employee.last_name AS employee_last_name,employee.image AS employee_image')
            ->leftJoin($this->getTableName('service') . ' AS service ON service.id=order_package.service_id')
            ->select('service.name AS service_name')
            ->leftJoin($this->getTableName('location') . ' AS location ON location.id=order_package.location_id')
            ->select('location.address as location_address')
            ->where('order_id=' . (int)$item->id)
        ;
        $item->list_order_package = $this->db->setQuery($query)->loadObjectList();
        $list_employee_full_name = [];
        $list_service_name = [];
        $package=[];
        foreach ($item->list_order_package as &$order_package) {
            $order_package->employee_full_name = $order_package->employee_first_name. ' ' .$order_package->employee_last_name;
            $list_employee_full_name[] = $order_package->employee_full_name;
            $list_service_name[] = $order_package->service_name;
            $query->clear()
                ->select("*")
                ->from($this->getTableName('order_package_rate').' AS order_package_rate')
                ->where('order_package_rate.order_package_id=' . (int)$order_package->id);
            $list_rate = $this->db->setQuery($query)->loadObjectList();
            foreach ($list_rate as &$rate) {
                $start_date = Factory::getDate($rate->start_date);
                $end_date = Factory::getDate($rate->end_date);
                $since_start = $start_date->diff($end_date);
                $rate->duration = $since_start->h. ' hours '. $since_start->i . ' minutes';
            }
            $order_package->rate = reset($list_rate);
            $query->clear()
                ->select('package.*')
                ->from($this->getTableName('package').' AS package')
                ->where('package.id='.(int)$order_package->package_id)
            ;
            $package=$this->db->setQuery($query)->loadObjectList();
        }
        $item->package=reset($package);
        return $item;
    }


}
