<?php
namespace WpBookingProAdmin\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use Exception;
use WpBookingPro\Factory;
use WpBookingPro\Filesystem\File as FileAlias;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
use WpBookingPro\Utilities\Utility;
class LocationModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "location";
    /**
     * @var string
     */
    public $table_name = "location";

    public function getItem($id=0){
        $table=$this->getTable();
        $key = $table->getKeyName();
        $input=Factory::getInput();
        if(!$id){
            $id=$input->getInt($key,0);
        }
        $db=Factory::getDBO();
        $query=$db->getQuery(true);
        $query->select('location.*')
            ->from($this->getTableName('location'). ' AS location')
            ->where($key.'='.(int)$id)
        ;
        $item=$this->db->setQuery($query)->loadObject();
        if(isset($item->id)&& $item->id!=0){
            $query->clear()
                ->select('DISTINCT gallery.*')
                ->from($this->getTableName('gallery').' AS gallery')
                ->where('object_id='.(int)$item->id)
                ->where('type='.$query->quote('destination'))
            ;
            $list_image= $this->_db->setQuery($query)->loadObjectList();
            $item->gallery=$list_image;

            $query->clear()
                ->select('country.countryname')
                ->from($this->getTableName('country').' AS country')
                ->where('country.phonecode='.(int)$item->phonecode)
                ->where('country.countrycode='.$query->quote($item->countrycode))
            ;
            $item->country_name = $this->_db->setQuery($query)->loadResult();
        }
        return $item;
    }


}
