<?php
use WpBookingPro\Factory;
use WpBookingPro\Filesystem\Folder;
use WpBookingPro\Html\WpBookingProHtmlFrontend;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);
$list_rolesetup = Folder::folders(WPBOOKINGPRO_APP_BACKEND_PATH.'/views');


$value1 = json_decode($value);


?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-rolesetup-<?php echo (esc_attr($name_format)) ?> field-rolesetup">
        <div class="wrapper-role">
            <ul class="list-role">
                <li class="role-item">
                    <label class="role-for-user">
                        <input type="checkbox" class="checked-all" value="access_backend" <?php echo (esc_attr(isset($value1->access_backend)?'checked':'')) ?> />
                        <?php esc_html_e('Access Backend','wpbookingpro')?>
                        <ul class="role-detail">
                            <li>
                                <label>
                                    <input type="checkbox" class="checked-single role-watch" value="watch" <?php echo(esc_attr(isset($value1->access_backend) && in_array('watch',$value1->access_backend) ? 'checked':'')) ?> />
                                    <?php esc_html_e('Watch','wpbookingpro');?>
                                </label>
                            </li>
                        </ul>
                    </label>
                </li>
                <?php foreach ($list_rolesetup as $item) {?>
                    <li class="role-item">
                        <label class="role-for-user">
                            <input type="checkbox" id="<?php echo (esc_attr($item))?>" class="checked-all" value="<?php echo (esc_attr($item))?>" <?php echo (esc_attr(isset($value1->{$item})? 'checked':''))?> />
                            <?php echo (esc_html(ucfirst( $item)))?>
                        </label>
                        <ul class="role-detail">
                            <li>
                                <label>
                                    <input type="checkbox" class="checked-single role-watch" value="watch" <?php echo(esc_attr(isset($value1->{$item}) && in_array('watch',$value1->{$item}) ? 'checked':'')) ?>/>
                                    <?php esc_html_e('Watch','wpbookingpro');?>
                                </label>
                            </li>
                            <li>
                                <label>
                                    <input type="checkbox" class="checked-single role-edit" value="edit" <?php echo(esc_attr(isset($value1->{$item}) && in_array('edit',$value1->{$item}) ? 'checked':'')) ?> disabled/>
                                    <?php esc_html_e('Edit','wpbookingpro');?>
                                </label>
                            </li>
                        </ul>
                    </li>
                <?php }?>
            </ul>
            <input type="hidden" name="<?php echo (esc_attr($name))?>" value="<?php echo (esc_attr($value))?>" />

        </div>
    </div>
<?php
$doc = Factory::getDocument();
WpBookingProHtmlFrontend::load_jquery_library('select2');
$doc->addLessStylesheet('admin/app/layouts/WooBooking/form/field/rolesetup/rolesetup.less');
$doc->addScriptApplySelector('.field-rolesetup','field_rolesetup',array(
        'field_name' => $name,
        'value'=>isset($value1) && !is_array($value1)?$value1:new stdClass()
),'admin/app/layouts/WooBooking/form/field/rolesetup/rolesetup.jquery.js');
