<?php

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
use WpBookingPro\Language\Text;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingProHtmlBackendAlias::load_jquery_library('select2');
$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$modelgroupuser = Model::getInstance('groupusers');
$list = $modelgroupuser->getList();
$list_time = [];
$list_country_id = [];
if (!is_array($value)) {
	$list_country_id[] = $value;
} else {
	$list_country_id = $value;
}
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-groupuser">
        <select name="<?php echo (esc_attr($name)); ?>"
                required="<?php echo (esc_attr($required)) ?>" <?php echo (esc_attr($multiple ? ' multiple ' : "")); ?>
                class="list-groupuser">
            <option value=""><?php esc_html_e('Select group user','wpbookingpro') ?></option>
			<?php foreach ($list as $item) { ?>
                <option <?php  echo (esc_attr(in_array($item->id, $list_country_id) ? ' selected ' : null)) ?>
                        value="<?php echo (esc_attr($item->id)); ?>"><?php echo (esc_html($item->name)); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/groupuser/groupuser.less');
$doc->addScriptApplySelector('.field-groupuser','field_groupuser',array(
),'admin/app/layouts/WooBooking/form/field/groupuser/groupuser.jquery.js');