"use strict";
(function ($) {
    $.field_editpass = function (element, options) {
        var defaults = {
            field_name: "",
            value:'',
            old_pass_ok:false,
            new_pass_ok:false,
            confirm_new_pass_ok:false,
            is_new_user:''
        };
        var plugin = this;
        plugin.settings = {}
        var $element = $(element),
            element = element;
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
        };
        plugin.convert_data_form = function() {
            var dataArray = $element.find('form[name="admin-form"]').serializeArray();
            var output = [];
            dataArray.forEach(function(item) {
                var existing = output.filter(function(v, i) {
                    return v.name == item.name;
                });
                if (existing.length) {
                    var existingIndex = output.indexOf(existing[0]);
                    output[existingIndex].value = output[existingIndex].value.concat(item.value);
                } else {
                    if (typeof item.value == 'string')
                        item.value = [item.value];
                    output.push(item);
                }
            });
            return output;
        };
        plugin.debounce = function(func, wait) {
            var timeout;

            return function() {
                var context = this,
                    args = arguments;

                var executeFunction = function() {
                    func.apply(context, args);
                };

                clearTimeout(timeout);
                timeout = setTimeout(executeFunction, wait);
            };
        };

        plugin.example_function = function () {
        };
        plugin.init();
    }

    $.fn.field_editpass = function (options) {

        return this.each(function () {

            if (undefined == $(this).data('field_editpass')) {
                var plugin = new $.field_editpass(this, options);
                $(this).data('field_editpass', plugin);
            }
        });
    }
})(jQuery);