"use strict";
(function ($) {
    $.field_cover = function (element, options) {
        var defaults = {
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element), 
            element = element;    
        
        plugin.init = function () {

            plugin.settings = $.extend({}, defaults, options);
            $element.find('.img-avatar').on('click',function (e) {
                $element.find('input[type="file"].upload').click();
            });
            $element.find('input[type="file"].upload').on('change',function () {
                plugin.readURL(this);
            });
        };
        plugin.readURL = function (input) {
            if (input.files && input.files[0]) {
                let reader = new FileReader();
                var validImageTypes = ["image/jpeg"];
                var fileType = input.files[0]["type"];
                reader.onload = function (e) {
                    if ($.inArray(fileType, validImageTypes) < 0) {
                        alert("File type must have extention .jpg or .jpeg");
                        return false;
                    }
                    $element.find('.img-avatar').attr('src', e.target.result);
                }
                reader.readAsDataURL(input.files[0]);
            }
        }
        plugin.example_function = function () {
        };
        plugin.init();
    }
    
    $.fn.field_cover = function (options) {
        
        return this.each(function () {
            
            if (undefined == $(this).data('field_cover')) {
                var plugin = new $.field_cover(this, options);
                $(this).data('field_cover', plugin);
            }
        });
    }
})(jQuery);