<?php

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
use WpBookingPro\Language\Text;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingProHtmlBackendAlias::load_jquery_library('select2');
$id_by_name = "element_field_". $name;
$list_color = [
    '#e6194b',
    '#3cb44b',
    '#ffe119',
    '#4363d8',
    '#f58231',
    '#911eb4',
    '#46f0f0',
    '#f032e6',
    '#bcf60c',
    '#fabebe',
    '#008080',
    '#e6beff',
    '#9a6324',
    '#fffac8',
    '#800000',
    '#aaffc3',
    '#808000',
    '#ffd8b1',
    '#000075',
    '#808080',
    '#ffffff',
    '#000000'
];
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-colorpicker">
        <ul class="list-color">
            <?php foreach ($list_color as $color) { ?>
                <li>
                    <div class="color-item <?php echo($value == $color ? ' active ' : '') ?>"
                         data-color="<?php echo (esc_attr($color)) ?>" style="background: <?php esc_html_e($color) ?>"><i
                            class="fas fa-check checked"></i></div>
                </li>
            <?php } ?>
        </ul>
        <input type="hidden" name="<?php echo (esc_attr($name)); ?>" value="<?php echo (esc_attr($value)) ?>" />
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin/app/layouts/WooBooking/form/field/colorpicker/colorpicker.less');
$doc->addScriptApplySelector('.field-colorpicker','field_colorpicker',array(
        'input_name'=> $name
),'admin/app/layouts/WooBooking/form/field/colorpicker/colorpicker.jquery.js');