"use strict";
(function ($) {
    $.field_asignservice = function (element, options) {
        var defaults = {
            field_name_start_time:'',
            field_name_end_time:'',
            field_name_price:'',
            list_category:[],
            item_employee_custom:''
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element), 
            element = element;    
        
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let field_name_start_time = plugin.settings.field_name_start_time;
            let field_name_end_time = plugin.settings.field_name_end_time;
            let field_name_price = plugin.settings.field_name_price;
            let list_category = plugin.settings.list_category;
            let list_order_service = [];

            let $ckb_service_name = $element.find('input.ckb-service-name');
            $ckb_service_name.on('change', function () {
                let service_id = $(this).val();
                if($(this).is(":checked")) {
                    list_order_service.push(parseInt(service_id));
                    $element.find('input[name="order_service"]').val(JSON.stringify(list_order_service));
                } else {
                    let index = list_order_service.indexOf(parseInt(service_id));
                    list_order_service.splice(index,1);
                    $element.find('input[name="order_service"]').val(JSON.stringify(list_order_service));
                }
            });
            $.each($ckb_service_name, function (index, item) {
                let $block_service_item = $(this).closest('.block-service-item');
                let service_id = $block_service_item.data('service_id');
                let $wrapper_item_employee_custom = $block_service_item.find('.wrapper-item-employee-custom');
                if($(item).is(":checked")) {
                    $block_service_item.find('input[type="text"]').prop('disabled', false);
                    $block_service_item.find('button').prop('disabled', false);
                    for(let i= 0; i< $wrapper_item_employee_custom.length; i++) {
                        list_order_service.push(service_id);
                        $element.find('input[name="order_service"]').val(JSON.stringify(list_order_service));
                    }
                    $block_service_item.find('.block-start-time input[type="hidden"]').attr('name', field_name_start_time);
                    $block_service_item.find('.block-end-time input[type="hidden"]').attr('name', field_name_end_time);
                    $block_service_item.find('.block-price input[type="hidden"]').attr('name', field_name_price);
                } else {
                    $block_service_item.find('input[type="text"]').prop('disabled', true);
                    $block_service_item.find('button').prop('disabled', true);
                    $block_service_item.find(`input[type="hidden"]`).attr('name','');
                }
            });

            $element.find('input[name="order_service"]').val(JSON.stringify(list_order_service));

            $element.find('input.ckb-service-name').on('change', function () {
                let $block_service_item = $(this).closest('.block-service-item');
                if($(this).is(":checked")) {
                    $block_service_item.find('input[type="text"]').prop('disabled', false);
                    $block_service_item.find('button').prop('disabled', false);
                    $block_service_item.find('.block-start-time input[type="hidden"]').attr('name', field_name_start_time);
                    $block_service_item.find('.block-end-time input[type="hidden"]').attr('name', field_name_end_time);
                    $block_service_item.find('.block-price input[type="hidden"]').attr('name', field_name_price);
                } else {
                    $block_service_item.find('input[type="text"]').prop('disabled', true);
                    $block_service_item.find('button').prop('disabled', true);
                    $block_service_item.find(`input[type="hidden"]`).attr('name','')
                }
            });

            $element.find('.start-time-input').daterangepicker({
                singleDatePicker: true,
                datePicker: false,
                timePicker: true,
                timePicker24Hour: false,
                timePickerIncrement: 10,
                locale: {
                    format: 'LT'
                }
            }).on('show.daterangepicker', function (ev, picker) {
                picker.container.find(".calendar-table").hide();
            });
            $element.find('.start-time-input').on('change', function () {
                let date = moment($(this).val(), "HH:mm:ss").add(1, 'h');
                let $wrapper_item_employee_custom = $(this).closest('.wrapper-item-employee-custom');
                $wrapper_item_employee_custom.find(`input[name="${field_name_start_time}"]`).val(moment($(this).val(),'LT').format('HH:mm:ss'));
                $wrapper_item_employee_custom.find(`input[name="${field_name_end_time}"]`).val(date.format('HH:mm:ss'));
                $wrapper_item_employee_custom.find(`input.end-time-input`).val(date.format('LT'));

            });
            $element.find('.end-time-input').daterangepicker({
                singleDatePicker: true,
                datePicker: false,
                timePicker: true,
                timePicker24Hour: false,
                timePickerIncrement: 10,
                locale: {
                    format: 'LT'
                }
            }).on('show.daterangepicker', function (ev, picker) {
                picker.container.find(".calendar-table").hide();
            });
            $element.find('.end-time-input').on('change', function () {
                let $wrapper_item_employee_custom = $(this).closest('.wrapper-item-employee-custom');
                $wrapper_item_employee_custom.find(`input[name="${field_name_end_time}"]`).val(moment($(this).val(),'LT').format('HH:mm:ss'));
            });
            $element.find('input.price-input').autoNumeric('init');
            $element.find('input.price-input').on('keyup', function () {
                let $wrapper_item_employee_custom = $(this).closest('.wrapper-item-employee-custom');
                $wrapper_item_employee_custom.find(`input[name="${field_name_price}"]`).val($(this).autoNumeric('get'));
            });
            $element.find('.btn-add-employee-custom').on('click', function(e) {
                let $wrapper_custom = $(this).closest('.wrapper-custom');
                plugin.set_task_when_click($wrapper_custom,list_order_service);
            });

            $element.find('.wrapper-item-employee-custom').each(function (index, item) {
                plugin.init_event_service_item($(item),list_order_service)
            });

        };
        plugin.init_event_service_item = function ($item_employee_custom,list_order_service) {
            $item_employee_custom.find('.btn-delete-employee-custom').click(function (e) {
                let $block_service_item = $(this).closest('.block-service-item');
                let service_id = $block_service_item.data('service_id');
                if ($block_service_item.find('.wrapper-item-employee-custom').length > 1) {
                    let index = list_order_service.indexOf(service_id);
                    list_order_service.splice(index,1);
                    $item_employee_custom.remove();
                    $element.find('input[name="order_service"]').val(JSON.stringify(list_order_service));
                }
            })
        };
        plugin.set_task_when_click = function ($wrapper_custom,list_order_service) {
            let field_name_start_time = plugin.settings.field_name_start_time;
            let field_name_end_time = plugin.settings.field_name_end_time;
            let field_name_price = plugin.settings.field_name_price;
            let list_category = plugin.settings.list_category;
            let $item_employee_custom = $(plugin.settings.item_employee_custom);
            let $block_service_item = $wrapper_custom.closest('.block-service-item');
            let service_id = $block_service_item.data('service_id');
            $item_employee_custom.appendTo($wrapper_custom);
            list_order_service.push(service_id);
            $element.find('input[name="order_service"]').val(JSON.stringify(list_order_service));
            $item_employee_custom.find('.start-time-input').daterangepicker({
                singleDatePicker: true,
                datePicker: false,
                timePicker: true,
                timePicker24Hour: false,
                timePickerIncrement: 10,
                locale: {
                    format: 'LT'
                }
            }).on('show.daterangepicker', function (ev, picker) {
                picker.container.find(".calendar-table").hide();
            });
            $item_employee_custom.find('.start-time-input').on('change', function () {
                let date = moment($(this).val(), "HH:mm:ss").add(1, 'h');
                let $wrapper_item_employee_custom = $(this).closest('.wrapper-item-employee-custom');
                $wrapper_item_employee_custom.find(`input[name="${field_name_start_time}"]`).val(moment($(this).val(),'LT').format('HH:mm:ss'));
                $wrapper_item_employee_custom.find(`input[name="${field_name_end_time}"]`).val(date.format('HH:mm:ss'));
                $wrapper_item_employee_custom.find(`input.end-time-input`).val(date.format('LT'));
            });
            $item_employee_custom.find('.end-time-input').daterangepicker({
                singleDatePicker: true,
                datePicker: false,
                timePicker: true,
                timePicker24Hour: false,
                timePickerIncrement: 10,
                locale: {
                    format: 'LT'
                }
            }).on('show.daterangepicker', function (ev, picker) {
                picker.container.find(".calendar-table").hide();
            });
            $item_employee_custom.find('.end-time-input').on('change', function () {
                let $wrapper_item_employee_custom = $(this).closest('.wrapper-item-employee-custom');
                $wrapper_item_employee_custom.find(`input[name="${field_name_end_time}"]`).val(moment($(this).val(),'LT').format('HH:mm:ss'));
            });
            $item_employee_custom.find('input.price-input').autoNumeric('init');
            $item_employee_custom.find('input.price-input').on('keyup', function () {
                let $wrapper_item_employee_custom = $(this).closest('.wrapper-item-employee-custom');
                $wrapper_item_employee_custom.find(`input[name="${field_name_price}"]`).val($(this).autoNumeric('get'));
            });
            $item_employee_custom.find('.btn-add-employee-custom').on('click',function (e) {
                let $wrapper_custom_1 = $(this).closest('.wrapper-custom');
                plugin.set_task_when_click($wrapper_custom_1,list_order_service);
            });
            plugin.init_event_service_item($item_employee_custom,list_order_service);
        }
        plugin.example_function = function () {
        };
        plugin.init();
    }
    
    $.fn.field_asignservice = function (options) {
        
        return this.each(function () {
            
            if (undefined == $(this).data('field_asignservice')) {
                var plugin = new $.field_asignservice(this, options);
                $(this).data('field_asignservice', plugin);
            }
        });
    }
})(jQuery);