"use strict";
(function ($) {
    $.view_form_service = function (element, options) {
        let defaults = {
            row_state_template: "",
            list_category_id:[],
            user_id:''
        };
        let plugin = this;
        plugin.settings = {};
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let $category_select = $element.find('select[name="category_id"]');
            let $vendor_select = $element.find('select[name="user_id"]');
            $category_select.on('change', function () {
                let category_id = $(this).val();
                let data = {
                    category_id: category_id,
                    task: "category.ajax_get_user_id"
                };
                if(plugin.settings.list_category_id.length === 0) {
                    $.ajax({
                        type: "POST",
                        dataType: "json",
                        url: wpbookingpro_root_url + wpbookingpro_api_task,
                        data: data,
                        beforeSend: function () {
                            $('body').loadingModal();
                        },
                        error: function (xhr) {
                            $.alert({
                                title: 'Error',
                                content: 'there are some error please contact admin !',
                            });
                        },
                        complete: function () {
                            $('body').loadingModal('destroy');
                        },
                        success: function (response) {
                            response = JSON.parse(response);
                            let user_id = response.data;
                            plugin.settings.user_id = user_id;
                            let $vendor_option = $element.find('select[name="user_id"] option');
                            $vendor_option.each(function (index, item) {
                                let val = item.value;
                                item.disabled = true;
                                if(val === user_id) {
                                    item.disabled = false;
                                }

                            });
                            if(user_id > 0) {
                                $element.find('select[name="user_id"]').val(user_id).trigger('change')
                            } else {
                                $element.find('select[name="user_id"]').val('').trigger('change')
                            }

                        }
                    });
                }

            });
            $vendor_select.on('change', function () {
                let user_id = $(this).val();
                let data = {
                    user_id: user_id,
                    task: "vendor.ajax_get_list_category"
                };
                if(plugin.settings.user_id === ''){
                    $.ajax({
                        type: "POST",
                        dataType: "json",
                        url: wpbookingpro_root_url + wpbookingpro_api_task,
                        data: data,
                        beforeSend: function () {
                            $('body').loadingModal();
                        },
                        error: function (xhr) {
                            $.alert({
                                title: 'Error',
                                content: 'there are some error please contact admin !',
                            });
                        },
                        complete: function () {
                            $('body').loadingModal('destroy');
                        },
                        success: function (response) {
                            response = JSON.parse(response);
                            let list_category_id = response.data;
                            plugin.settings.list_category_id = list_category_id;
                            let $category_option = $element.find('select[name="category_id"] option');
                            $category_option.each(function (index, item) {
                                let val = item.value;
                                item.disabled = true;
                                list_category_id.map(function (category_id) {
                                    if(val === category_id) {
                                        item.disabled = false;
                                    }
                                });

                            });

                        }
                    });
                }

            })
        };
        plugin.getMinValueInArray = function (arr ) {
            let min = arr[0];
            for (let i = 0; i < arr.length; i++) {
                if(new Date(min).getTime() > new Date(arr[i]).getTime()) {
                    min = arr[i]
                }
            }
            return min;
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }
    $.fn.view_form_service = function (options) {
        return this.each(function () {
            if (undefined === $(this).data('view_form_service')) {
                let plugin = new $.view_form_service(this, options);
                $(this).data('view_form_service'
                    , plugin);
            }
        });
    }
})(jQuery);
