<?php
/**
 * Plugin Name: WooCommerce Loyalty Points and Rewards
 * Plugin URI: https://www.flycart.org
 * Description: Loyalty Points, Rewards and Referrals for WooCommerce. Turn your hard earned sales into repeat purchases by rewarding your customers and building loyalty.
 * Version: 1.2.17
 * Author: Flycart
 * Slug: wp-loyalty-points-rewards
 * Text Domain: wp-loyalty-points-rewards
 * Domain Path: /i18n/languages/
 * Requires at least: 4.9.0
 * WC requires at least: 3.0.9
 * WC tested up to: 6.1.0
 * Contributors: flycart, Alagesan
 * Author URI: https://www.flycart.org
 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
defined('ABSPATH') OR die;
//Define the plugin version
defined('WLPR_PLUGIN_VERSION') OR define('WLPR_PLUGIN_VERSION', '1.2.17');
// Define the plugin text domain
defined('WLPR_TEXT_DOMAIN') OR define('WLPR_TEXT_DOMAIN', 'wp-loyalty-points-rewards');
// Define the slug
defined('WLPR_PLUGIN_SLUG') OR define('WLPR_PLUGIN_SLUG', 'wp-loyalty-points-rewards');
// Define plugin path
defined('WLPR_PLUGIN_PATH') OR define('WLPR_PLUGIN_PATH', __DIR__ . '/');
// Define plugin URL
defined('WLPR_PLUGIN_URL') OR define('WLPR_PLUGIN_URL', plugin_dir_url(__FILE__));
// Define plugin file
defined('WLPR_PLUGIN_FILE') OR define('WLPR_PLUGIN_FILE', __FILE__);
// Define plugin prefix
defined('WLPR_PLUGIN_PREFIX') OR define('WLPR_PLUGIN_PREFIX', 'wlpr');
//Define the plugin language
defined('WLPR_PLUGIN_LANGUAGE') OR define('WLPR_PLUGIN_LANGUAGE', get_locale());
//defined plugin name
defined('WLPR_PLUGIN_NAME') OR define('WLPR_PLUGIN_NAME', 'WP Rewards - WooCommerce Loyalty Points and Rewards');
defined('WLPR_MINIMUM_PHP_VERSION') OR define('WLPR_MINIMUM_PHP_VERSION', '5.6.0');
defined('WLPR_MINIMUM_WP_VERSION') OR define('WLPR_MINIMUM_WP_VERSION', '4.9');
defined('WLPR_MINIMUM_WC_VERSION') OR define('WLPR_MINIMUM_WC_VERSION', '3.0.9');

if(!function_exists('isWoocommerceActive')) {
    function isWoocommerceActive()
    {
        $active_plugins = apply_filters('active_plugins', get_option('active_plugins', array()));
        if (is_multisite()) {
            $active_plugins = array_merge($active_plugins, get_site_option('active_sitewide_plugins', array()));
        }
        return in_array('woocommerce/woocommerce.php', $active_plugins, false) || array_key_exists('woocommerce/woocommerce.php', $active_plugins);
    }
}

if(!isWoocommerceActive()) return;


// Autoload the vendor
if (!file_exists(__DIR__ . '/vendor/autoload.php')) {
    return false;
} else {
    require __DIR__ . '/vendor/autoload.php';
}
include_once WLPR_PLUGIN_PATH . 'App/Api/RestApi.php';
//Init the router
$router = new \Wlpr\App\Router();
$router->init();