if (typeof (wlpr_jquery) == 'undefined') {
    wlpr_jquery = jQuery.noConflict();
}

wlpr = window.wlpr || {};
(function (wlpr) {
    wlpr.toggleLauncher = function () {
        wlpr_jquery('#wlpr-launcher-preview-content').toggle();
        let width = wlpr_jquery( window ).width();
        if(width < 768){
            wlpr_jquery('#wlpr-launcher-preview-icon').toggle();
        }
    };

    wlpr.toogleBirthDate = function(){
        wlpr_jquery('#wlpr-birthday-edit').toggle();
    };
    wlpr.saveBirthDate = function () {
        var data = {
            birth_date : wlpr_jquery('#wlpr_birth_date_id').val(),
            action: 'wlpr_save_birth_date',
            security: wlpr_localize_data.apply_coupon_nonce
        };
        wlpr_jquery('#wlpr-birth-date-save-button').attr('disabled', true);
        wlpr_jquery.ajax({
            data: data,
            type: 'post',
            url: wlpr_localize_data.ajax_url,
            error: function (request, error) {
                /*alertify.error(error);*/
                console.log(error);
            },
            success: function (json) {
                wlpr_jquery('#wlpr-birth-date-save-button').attr('disabled', false);
                if (json.success) {
                    window.location.reload();
                }
            }
        });
    };
})(wlpr);
(function () {
    wlpr_jquery('#wlpr-launcher-box').scroll(function() {
        var scroll = wlpr_jquery(window).scrollTop();
        if (scroll >= 500) {
            wlpr_jquery("#wlpr-launcher-header .wlpr-launcher-above-close").addClass("wlpr-scroll-button");
        }
    });
})(wlpr_jquery);
