/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */

if (typeof (wlpr_jquery) == 'undefined') {
    wlpr_jquery = jQuery.noConflict();
}

wlpr = window.wlpr || {};
(function (wlpr) {
    wlpr.copyLink = function (link_id) {
        /* Get the text field */
        var copyText = document.getElementById(link_id);
        /* Select the text field */
        copyText.select();
        copyText.focus();
        copyText.select();
        document.execCommand('copy');
    };
    wlpr.twitterShare = function (url) {
        window.open(url,'tweeter-share-dialog','width=626, height=436');
        wlpr.award_social_point('wlpr_twitter_share_reward');
    };
    wlpr.whatsAppShare = function (url) {
        window.open(url, 'whats-app-share','width=626, height=436');
        wlpr.award_social_point('wlpr_whats_app_share');
    };
    wlpr.emailShare = function (url){
        wlpr.award_social_point('wlpr_email_share_reward');
        window.open(url, '_blank');
    };

    wlpr.shareFB = function (url) {
        wlpr.award_social_point('wlpr_facebook_share_reward');
        window.open(url, '_blank');
    };
    wlpr.award_social_point = function(parm_action) {
        var data = {
            action: parm_action,
            security: wlpr_localize_data.apply_share_nonce
        };
        wlpr_jquery.ajax({
            data: data,
            type: 'post',
            url: wlpr_localize_data.ajax_url,
            error: function (request, error) {
                /*alertify.error(error);*/
                console.log(error);
            },
            success: function (json) {
            }
        });
    };
    wlpr.removeFee = function (fee_id) {
        var is_checkout = wlpr_jquery("#wlpr_is_checkout").val();
        var data = {
            action: "wlpr_loyal_point_remove_fee",
            fee_id: fee_id,
            security: ( wlpr_localize_data.apply_coupon_nonce ? wlpr_localize_data.apply_coupon_nonce : wc_checkout_params.apply_coupon_nonce )
        };
        wlpr_jquery.ajax({
            type:     "POST",
            url:      wlpr_localize_data.ajax_url,
            data:     data,
            success:  function( json ) {
                wlpr_points_applied = true;

                wlpr_jquery( ".woocommerce-error, .woocommerce-message" ).remove();

                if(json.success && is_checkout){
                    wlpr_jquery( "body" ).trigger( "update_checkout" );
                }else{
                    window.location.reload();
                }
            },
            dataType: "json"
        });
    };
    wlpr.show_notice = function (html_element, $target) {
        if (!$target) {
            $target = wlpr_jquery('.woocommerce-notices-wrapper:first') ||
                wlpr_jquery('.cart-empty').closest('.woocommerce') ||
                wlpr_jquery('.woocommerce-cart-form');
        }
        $target.prepend(html_element);
    };
})(wlpr);
(function () {
    wlpr_jquery(document).on('ready',function () {
        wlpr_jquery('#billing_email_field').addClass('address-field');
    });
    alertify.set('notifier', 'position', 'top-right');
    wlpr_jquery(document).on("click", "#wlpr_point_apply_discount_button", function (e) {
        var is_partial = wlpr_jquery("#wlpr_is_partial").val();
        var is_checkout = wlpr_jquery("#wlpr_is_checkout").val();
        if (is_partial == 1) {
            e.preventDefault();
            alertify.prompt(wlpr_localize_data.checkout_partial_discount_message,0,function (evt, value) {
                wlpr_jquery( "#wlpr_point_apply_discount_amount" ).val( value );
                var data = {
                    action: "wlpr_apply_loyal_discount",
                    discount_amount: value,
                    wlpr_none: wlpr_localize_data.wlpr_discount_none,
                };
                wlpr_jquery.ajax({
                    type: "POST",
                    url: wlpr_localize_data.ajax_url,
                    data: data,
                    dataType: "json",
                    success: function (json) {
                        if (is_checkout == 1) {
                            if (json.success) {
                                wlpr_jquery(document.body).trigger("update_checkout", {update_shipping_method: true});
                            }
                        } else {
                            wlpr_jquery('.woocommerce-error, .woocommerce-message, .woocommerce-info').remove();
                            if (json.data.message) {
                                wlpr.show_notice(json.data.message);
                            }
                            wlpr_jquery(document.body).trigger('wc_update_cart', true);
                        }
                    }
                });
            }).setHeader('');
            return false;
        }else {
            var data = {
                action: "wlpr_apply_loyal_discount",
                discount_amount: wlpr_jquery("#wlpr_discount_point").val(),
                wlpr_none: wlpr_localize_data.wlpr_discount_none,
            };
            wlpr_jquery.ajax({
                type: "POST",
                url: wlpr_localize_data.ajax_url,
                data: data,
                dataType: "json",
                success: function (json) {
                    if (is_checkout == 1) {
                        if (json.success) {
                            wlpr_jquery(document.body).trigger("update_checkout", {update_shipping_method: true});
                        }
                    } else {
                        wlpr_jquery('.woocommerce-error, .woocommerce-message, .woocommerce-info').remove();
                        if (json.data.message) {
                            wlpr.show_notice(json.data.message);
                        }
                        wlpr_jquery(document.body).trigger('wc_update_cart', true);
                    }
                }
            });
        }

        return false;
    });
})(wlpr_jquery);
