/*
 * Customizer Scripts
 * Need to rewrite and clean up this file.
 */

jQuery(document).ready(function() {
    /**
     * Change description
     */
    jQuery('#customize-info .customize-panel-description').html(wlpr_launcher.labels.description);
    jQuery('#customize-info .panel-title.site-title').html(wlpr_launcher.labels.customtitle);
    // Add reset button
    jQuery('#customize-header-actions input#save').after('<input type="submit" name="wlpr_launcher_reset" id="wlpr_launcher_reset" class="button button-secondary" value="' + wlpr_launcher.labels.reset + '" style="float: right; margin-left: 8px; margin-top: 0px;">');

    // Handle reset button click
    jQuery('#customize-header-actions #wlpr_launcher_reset').click(function(e) {

        // Prevent form submit
        e.preventDefault();

        // Display confirmation prompt
        var confirmation = confirm(wlpr_launcher.labels.reset_confirmation);

        // Check user input
        if ( ! confirmation ) {
            return;
        }

        // Disable reset button
        jQuery(this).prop('disabled', true);

        // Populate request data object
        var data = {
            wp_customize:   'on',
            action:         'wlpr_launcher_reset',
        };

        // Send request to server
        jQuery.post(wlpr_launcher.ajax_url, data, function() {
            wp.customize.state('saved').set(true);
            window.location.replace(wlpr_launcher.customizer_url);
        });
    });

    jQuery('#customize-control-wlpr_launcher_preview_customer_button #_customize-input-wlpr_launcher_preview_customer_button').click(function (e) {
        jQuery('#customize-save-button-wrapper #save').trigger('click');
        setTimeout(function(){
            window.location.replace(wlpr_launcher.customizer_url);
        }, 3000);
    });

    jQuery( '.image-radio-select label' ).on( 'click', function(e) {
        var new_val = jQuery(this).attr('data-image-value');
        jQuery('#wlpr-launcher-prebuilt-template').val(new_val);
        jQuery('.image-radio-select label.wlpr-active').each( function () {
            jQuery(this).removeClass("wlpr-active");
        });
        jQuery(this).addClass("wlpr-active");
    });

    // Handle mobile button click
    function custom_size_mobile() {
        // get email width.
        var email_width = parseInt( jQuery('#customize-control-wlpr_launcher_content_width .range-slider__range').val() );
        var ratio = 380/email_width;
        var framescale = 100/ratio;
        var framescale = framescale/100;
        jQuery('#customize-preview iframe').width(email_width+'px');
        jQuery('#customize-preview iframe').css({
            '-webkit-transform' : 'scale(' + ratio + ')',
            '-moz-transform'    : 'scale(' + ratio + ')',
            '-ms-transform'     : 'scale(' + ratio + ')',
            '-o-transform'      : 'scale(' + ratio + ')',
            'transform'         : 'scale(' + ratio + ')'
        });
    }
    jQuery('#customize-footer-actions .preview-mobile').click(function(e) {
        if ( wlpr_launcher.responsive_mode ) {
            jQuery('#customize-preview iframe').width('100%');
            jQuery('#customize-preview iframe').css({
                '-webkit-transform' : 'scale(1)',
                '-moz-transform'    : 'scale(1)',
                '-ms-transform'     : 'scale(1)',
                '-o-transform'      : 'scale(1)',
                'transform'         : 'scale(1)'
            });
        } else {
            custom_size_mobile();
        }
    });

    jQuery('#customize-footer-actions .preview-desktop').click(function(e) {
        jQuery('#customize-preview iframe').width('100%');
        jQuery('#customize-preview iframe').css({
            '-webkit-transform' : 'scale(1)',
            '-moz-transform'    : 'scale(1)',
            '-ms-transform'     : 'scale(1)',
            '-o-transform'      : 'scale(1)',
            'transform'         : 'scale(1)'
        });
    });
    jQuery('#customize-footer-actions .preview-tablet').click(function(e) {
        jQuery('#customize-preview iframe').width('100%');
        jQuery('#customize-preview iframe').css({
            '-webkit-transform' : 'scale(1)',
            '-moz-transform'    : 'scale(1)',
            '-ms-transform'     : 'scale(1)',
            '-o-transform'      : 'scale(1)',
            'transform'         : 'scale(1)'
        });
    });

});

( function( $ ) {

    var WLPR_EX = {

        init: function() {
            $( 'input[name=wlpr-launcher-export-button]' ).on( 'click', WLPR_EX._export );
            $( 'input[name=wlpr-launcher-import-button]' ).on( 'click', WLPR_EX._import );
        },

        _export: function() {
            window.location.href = WLPR_EX_Config.customizerURL + '&wlpr-launcher-export=' + WLPR_EX_Config.exportNonce;
        },

        _import: function() {

            // Display confirmation prompt
            var confirmation = confirm(WLPR_l10n.confrim_override);

            // Check user input
            if ( ! confirmation ) {
                return;
            }

            var win			= $( window ),
                body		= $( 'body' ),
                form		= $( '<form class="wlpr-launcher-import-form" method="POST" enctype="multipart/form-data"></form>' ),
                controls	= $( '.wlpr-launcher-import-controls' ),
                file		= $( 'input[name=wlpr-launcher-import-file]' ),
                message		= $( '.wlpr-launcher-uploading' );

            if ( '' == file.val() ) {
                alert( WLPR_l10n.emptyImport );
            } else {
                win.off( 'beforeunload' );
                body.append( form );
                form.append( controls );
                message.show();
                form.submit();
            }
        }
    };

    $( WLPR_EX.init );

})( jQuery );

( function( $ ) {

    var WLPR_IMPORT = {

        init: function() {
            $( 'input[name=wlpr-launcher-template-button]' ).on( 'click', WLPR_IMPORT._import_template );
        },
        _import_template: function() {

            // Display confirmation prompt
            var confirmation = confirm(WLPR_l10n.confrim_override);

            // Check user input
            if ( ! confirmation ) {
                return;
            }
            var win			= $( window ),
                body		= $( 'body' ),
                form		= $( '<form class="wlpr-launcher-template-form" method="POST" enctype="multipart/form-data"></form>' ),
                controls	= $( '.wlpr-template-launcher-load-controls' ),
                message		= $( '.wlpr-launcher-loading' );

            win.off( 'beforeunload' );
            body.append( form );
            form.append( controls );
            message.show();
            form.submit();
        }
    };

    $( WLPR_IMPORT.init );

})( jQuery );
