/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */

if (typeof (wlpr_jquery) == 'undefined') {
    wlpr_jquery = jQuery.noConflict();
}

wlpr = window.wlpr || {};
(function (wlpr) {
    wlpr.selectCb = function (){
        if(wlpr_jquery('#cb-all').is(":checked")){
            let checkbox = wlpr_jquery('table .cb');
            wlpr_jquery.each(checkbox,function (index,value) {
                wlpr_jquery(value).prop('checked', true);
            });
        }else {
            let checkbox = wlpr_jquery('table .cb');
            wlpr_jquery.each(checkbox,function (index,value) {
                wlpr_jquery(value).prop('checked', false);
            });
        }
    };
    wlpr.changeAllCb = function(id){
        if(!wlpr_jquery('.cb-'+id).is(":checked")){
            wlpr_jquery('#cb-all').prop('checked', false);
        }
    };
    wlpr.bulk_delete_user = function(){
        let checked_list = wlpr_jquery("input[name='cb[]']:checked").serialize();
        alertify.confirm(wlpr_localize_data.user_delete_title, wlpr_localize_data.user_delete_content, function(){
                wlpr_jquery.ajax({
                    data: '&action=wlpr_bulk_delete_user&wlpr_none='+wlpr_localize_data.wlpr_delete_user_none+'&'+checked_list,
                    type: 'post',
                    url: wlpr_localize_data.ajax_url,
                    error: function (request, error) {
                        /*alertify.error(error);*/
                        console.log(error);
                    },
                    success: function (json) {
                        if (json.error) {
                            alertify.error(json.message);
                        } else {
                            alertify.success(json.message);
                            if (json.redirect) {
                                window.location = json.redirect;
                            }
                        }

                    }
                }); }
            , function(){

            });
    };
    wlpr.saveSettings = function () {
        var data = wlpr_jquery('#wlpr-settings_form').serialize();
        wlpr_jquery('#wlpr-setting-submit-button').attr('disabled', true);
        wlpr_jquery('.wlpr-error').remove();
        wlpr_jquery.ajax({
            data: data,
            type: 'post',
            url: wlpr_localize_data.ajax_url,
            error: function (request, error) {
                /*alertify.error(error);*/
                console.log(error);
            },
            success: function (json) {
                var license_key_message_conteiner = wlpr_jquery(".license_key_message");
                if (json.license_key) {
                    if (json.license_key_message) {
                        license_key_message_conteiner.css("color", "green");
                        license_key_message_conteiner.html(json.license_key_message);
                    }
                }
                if (!json.license_key) {
                    if (json.license_key_message) {
                        license_key_message_conteiner.css("color", "red");
                        license_key_message_conteiner.html(json.license_key_message);
                    }
                }
                wlpr_jquery('#wlpr-setting-submit-button').attr('disabled', false);
                if (json.error) {
                    alertify.error(json.message);
                    if(json.field_error){
                        wlpr_jquery.each(json.field_error,function (index,value) {
                            alertify.error(value);
                            wlpr_jquery('#wlpr-settings_form input[name='+index+'], #wlpr-settings_form textarea[name='+index+'],#wlpr-settings_form select[name='+index+']').after('<span class="wlpr-error" style="color: red;">'+value+'</span>');
                        });
                    }
                } else {
                    alertify.success(json.message);
                }
                if (json.redirect) {
                    window.location.href = json.redirect;
                }
            }
        });
    };
    wlpr.copyLink = function (link_id) {
        /* Get the text field */
        var copyText = document.getElementById(link_id);
        /* Select the text field */
        copyText.select();
        copyText.focus();
        copyText.select();
        document.execCommand('copy');
    };
    wlpr.twitterShare = function (url) {
        window.open(url,'tweeter-share-dialog','width=626, height=436');
        wlpr.award_social_point('wlpr_twitter_share_reward');
    };
    wlpr.emailShare = function (url){
        wlpr.award_social_point('wlpr_email_share_reward');
        window.open(url, '_blank');
    };
    wlpr.apply_point = function (user_email, user_id, redirect) {
        var point = wlpr_jquery('#customer_point_' + user_id).val();
        wlpr_jquery('#wlpr-setting-submit-button').attr('disabled', true);
        wlpr_jquery.ajax({
            data: 'user_email=' + encodeURIComponent(user_email) + '&point=' + point + '&action=wlpr_apply_point&wlpr_none='+wlpr_localize_data.wlpr_apply_point_none,
            type: 'post',
            url: wlpr_localize_data.ajax_url,
            error: function (request, error) {
                /*alertify.error(error);*/
                console.log(error);
            },
            success: function (json) {
                wlpr_jquery('#wlpr-setting-submit-button').attr('disabled', false);
                if (json.error) {
                    alertify.error(json.message);
                } else {
                    alertify.success(json.message);
                    wlpr_jquery('#wplr_customer_point').html(point);
                    wlpr_jquery('#wplr_customer_point').show();
                    wlpr_jquery('#wlpr_apply_point_setting').toggle();
                    if (json.redirect, redirect) {
                        window.location = json.redirect;
                    }
                }

            }
        });
    };
    wlpr.delete_user = function (user_email,redirect){
        alertify.confirm(wlpr_localize_data.user_delete_title, wlpr_localize_data.user_delete_content, function(){
            wlpr_jquery.ajax({
                data: 'user_email=' + encodeURIComponent(user_email) + '&action=wlpr_delete_user&wlpr_none='+wlpr_localize_data.wlpr_delete_user_none,
                type: 'post',
                url: wlpr_localize_data.ajax_url,
                error: function (request, error) {
                    /*alertify.error(error);*/
                    console.log(error);
                },
                success: function (json) {
                    if (json.error) {
                        alertify.error(json.message);
                    } else {
                        alertify.success(json.message);
                        if (json.redirect && redirect) {
                            window.location = json.redirect;
                        }
                    }

                }
            }); }
            , function(){

            });
    };
    wlpr.analysis_filter = function (form_id) {
        var form = wlpr_jquery('#' + form_id);
        var filter_date = wlpr_jquery('#filter_date').val();
        if (filter_date == 'custom') {
            wlpr_jquery('#filter_custom_date').show();
        } else {
            form.submit();
        }
    };

    wlpr.save_private_note = function (note_id, user_email) {
        var private_note = wlpr_jquery('#' + note_id).val();
        wlpr_jquery.ajax({
            data: {
                user_email: encodeURIComponent(user_email),
                private_note: private_note,
                action: 'wlpr_save_private_note',
                wlpr_none: wlpr_localize_data.wlpr_private_note_none
            },
            type: 'post',
            url: wlpr_localize_data.ajax_url,
            error: function (request, error) {
                /*alertify.error(error);*/
                console.log(error);
            },
            success: function (json) {
                wlpr_jquery('#wlpr-setting-submit-button').attr('disabled', false);
                if (json.error) {
                    alertify.error(json.message);
                } else {
                    alertify.success(json.message);
                    window.location = json.redirect;
                }
            }
        });
    };
    wlpr.addReferralRule = function () {
        var rule_key = parseInt(wlpr_jquery('#next_key').html());
        wlpr_jquery('#footer-referral-rule').remove();
        var rule_html = '';
        rule_html += '<tr class="refer-rule-' + rule_key + '">\n' +
            '                                <td>\n' +
            '                                    <select name="wlpr_rules[' + rule_key + '][rule_type]">\n';
        wlpr_jquery.each(wlpr_localize_data.rule_types, function (r_key, r_value) {
            rule_html += '<option value="' + r_key + '">' + r_value + '</option>';
        });

        rule_html += '                                    </select>\n' +
            '                                </td>\n';
        rule_html += '                                <td>\n' +
            '                                    <select name="wlpr_rules[' + rule_key + '][referral_type]">\n';
        wlpr_jquery.each(wlpr_localize_data.referral_types, function (ref_key, ref_value) {
            rule_html += '<option value="' + ref_key + '">' + ref_value + '</option>';
        });

        rule_html += '                                    </select>\n' +
            '                                </td>\n';
        rule_html += '                                <td>\n' + wlpr_localize_data.min_text +
            '                                    \n' +
            '                                    <input class="wlpr_rules-contrler" name="wlpr_rules[' + rule_key + '][rule_min]" type="number" oninput="validity.valid||(value=\'\');" min="0" \n' +
            '                                           value="0">\n' + wlpr_localize_data.max_text +
            '                                    \n' +
            '                                    <input class="wlpr_rules-contrler" name="wlpr_rules[' + rule_key + '][rule_max]" type="number" min="0" oninput="validity.valid||(value=\'\');" \n' +
            '                                           value="0">\n' +
            '                                </td>\n' +
            '                                <td>\n' +
            '                                    <input class="wlpr_rules-contrler" name="wlpr_rules[' + rule_key + '][earn_point]" type="number" min="0" oninput="validity.valid||(value=\'\');" \n' +
            '                                           value="0">\n' +
            ' <select class="wlpr_rules-contrler-select" name="wlpr_rules[' + rule_key + '][earn_point_type]">\n';
        wlpr_jquery.each(wlpr_localize_data.discount_types, function (r_key, r_value) {
            rule_html += '<option value="' + r_key + '">' + r_value + '</option>';
        });
        rule_html += '                                </select>\n' +
            '                                </td>\n' +
            '<td><a onclick="jQuery(\'.refer-rule-' + rule_key + '\').remove()"> <span class="dashicons dashicons-trash rule-remove"></span> ' + '</a></td>\n' +
            '                            </tr>';
        wlpr_jquery('#next_key').html(rule_key+1);
        wlpr_jquery('.refer-rule-' + (rule_key - 1)).after(rule_html);
    };
    wlpr.saveReferral = function () {
        var data = wlpr_jquery('#wlpr-referring-form').serialize();
        wlpr_jquery('#wlpr-referral-submit-button').attr('disabled', true);
        wlpr_jquery('.wlpr-error').remove();
        wlpr_jquery.ajax({
            data: data,
            type: 'post',
            url: wlpr_localize_data.ajax_url,
            error: function (request, error) {
                /*alertify.error(error);*/
                console.log(error);
            },
            success: function (json) {
                wlpr_jquery('#wlpr-referral-submit-button').attr('disabled', false);
                if (json.error) {
                    alertify.error(json.message);
                    if(json.field_error){
                        wlpr_jquery.each(json.field_error,function (index,value) {
                            alertify.error(value);
                            wlpr_jquery('#wlpr-referring-form input[name='+index+'], #wlpr-referring-form textarea[name='+index+'],#wlpr-referring-form select[name='+index+']').after('<span class="wlpr-error" style="color: red;">'+value+'</span>');
                        });
                    }
                } else {
                    alertify.success(json.message);
                }

            }
        });
    };
    wlpr.changeTemplateToActive = function (template) {
        wlpr_jquery.ajax({
            data: {action: 'wlpr_launcher_change',option_key: 'wlpr_active_template',template_key: template},
            type: 'post',
            url: wlpr_localize_data.ajax_url,
            error: function (request, error) {
                /*alertify.error(error);*/
                console.log(error);
            },
            success: function (json) {
                alertify.success(json.data);
                window.location.reload();
            }
        });
    };
    wlpr.filterAction = function (filter_order_id, filter_order_value, filter_dir_id, form_id) {
        wlpr_jquery('#' + filter_order_id).val(filter_order_value);
        var direction = wlpr_jquery('#' + filter_dir_id).val();
        if (direction == "DESC") {
            wlpr_jquery('#' + filter_dir_id).val('ASC');
        } else {
            wlpr_jquery('#' + filter_dir_id).val('DESC');
        }
        wlpr_jquery('#' + form_id).submit();
    };
    
    wlpr.openCustomTab = function (tab,content_id) {
        wlpr_jquery('#wlpr-referring-form .lpr-points-settings').hide();
        wlpr_jquery('#wlpr-settings_form .lpr-points-settings').hide();
        wlpr_jquery('.wlpr-setting-tab-link').removeClass('active');

        wlpr_jquery(tab).addClass('active');
        wlpr_jquery('#'+content_id).show();
    };
    wlpr.selectImage = function (input_id,image_id) {
        var media = wp.media({
            title: 'Select Media',
            multiple : false,
            library : {
                type : 'image',
            }
        });
        media.on('close',function() {
            var selection =  media.state().get('selection');
            selection.each(function(attachment) {
                url = attachment['attributes']['url'];
                if(url != undefined){
                    wlpr_jquery('#'+input_id).val(url);
                    wlpr_jquery('#'+image_id).attr('data-src',url);
                    wlpr_jquery('#'+image_id).attr('src',url);
                }
            });
        });
        media.open();
        return false;
    };
    wlpr.removeImage = function (input_id,image_id,image_src) {
        wlpr_jquery('#'+input_id).val(image_src);
        wlpr_jquery('#'+image_id).data('src',image_src);
        wlpr_jquery('#'+image_id).attr('src',image_src);
    };
    wlpr.importUsers = function () {
        var file = wlpr_jquery('#wlpr-import-file')[0].files[0];
        if(file.name){
            wlpr.showImportPre();
        }
    };

    wlpr.startExport = function () {
        var values = wlpr_jquery('#wlpr-export-preview-id').serializeArray();
        wlpr_jquery('#wlpr-process-export-button').attr('disabled',true);
        var request = wlpr_jquery.ajax({
            url: wlpr_localize_data.ajax_url,
            type: 'post',
            data: values,
            dataType: 'json',
            cache: false
        });
        request.done(function(json) {
            if(json['success'] !='completed') {
                wlpr_jquery('#limit_start').val(json['limit_start']);
                wlpr_jquery('#notification').html("<div class='alert success'>"+json['notification']+"</div>");
                var total_count = wlpr_jquery('#wlpr-total-count').val();
                if(total_count < json['limit_start']){
                    wlpr_jquery('#wlpr-process-count').html(total_count);
                }else {
                    wlpr_jquery('#wlpr-process-count').html(json['limit_start']);
                }
                wlpr.startExport();
            } else if(json['success'] =='completed'){
                wlpr_jquery('#notification').append("<div class='alert success'>Completed</div>");
            }
        });
    };

    wlpr.startImport = function () {
        var values = wlpr_jquery('#wlpr-imprt-preview-id').serializeArray();
        wlpr_jquery('#wlpr-process-import-button').attr('disabled',true);
        var request = wlpr_jquery.ajax({
            url: wlpr_localize_data.ajax_url,
            type: 'post',
            data: values,
            dataType: 'json',
            cache: false
        });
        request.done(function(json) {
            if(json['success'] !='completed') {
                wlpr_jquery('#limit_start').val(json['limit_start']);
                wlpr_jquery('#notification').html("<div class='alert success'>"+json['notification']+"</div>");
                var total_count = wlpr_jquery('#wlpr-total-count').val();
                if(total_count < json['limit_start']){
                    wlpr_jquery('#wlpr-process-count').html(total_count);
                }else {
                    wlpr_jquery('#wlpr-process-count').html(json['limit_start']);
                }
                wlpr.startImport();
            } else if(json['success'] =='completed'){
                wlpr_jquery('#notification').append("<div class='alert success'>Completed</div>");
            }
        });
    };
    wlpr.saveNewCustomer = function() {
        var values = wlpr_jquery('#wlpr-save-new-customer').serializeArray();
        wlpr_jquery('#wlpr-save-button').attr('disabled',true);
        var request = wlpr_jquery.ajax({
            url: wlpr_localize_data.ajax_url,
            type: 'post',
            data: values,
            dataType: 'json',
            cache: false
        });
        request.done(function(json) {
            if (json.error) {
                alertify.error(json.message);
            } else {
                alertify.success(json.message);
                window.location = json.redirect;
            }
        });
    };
    wlpr.startMigration = function(){

        var values = wlpr_jquery('#wlpr-migration-preview-id').serializeArray();
        wlpr_jquery('#wlpr-process-migration-button').attr('disabled',true);
        var request = wlpr_jquery.ajax({
            url: wlpr_localize_data.ajax_url,
            type: 'post',
            data: values,
            dataType: 'json',
            cache: false
        });
        request.done(function(json) {
            if(json['success'] == 'error'){
                alertify.error(json.message);
            } else if(json['success'] !='completed') {
                wlpr_jquery('#limit_start').val(json['limit_start']);
                var total_count = wlpr_jquery('#wlpr-total-count').val();
                if(total_count < json['limit_start']){
                    wlpr_jquery('#wlpr-process-count').html(total_count);
                }else {
                    wlpr_jquery('#wlpr-process-count').html(json['limit_start']);
                }
                wlpr.startMigration();
            } else if(json['success'] =='completed'){
                wlpr_jquery('#notification').append("<div class='alert success'>Completed</div>");
                window.location = json['redirect'];
            }
        });
    };

    wlpr.showpopup = function (task) {
        var request = wlpr_jquery.ajax({
            url: wlpr_localize_data.ajax_url,
            type: 'get',
            data: {
                action: task,
                wlpr_none: wlpr_localize_data.wlpr_popup_none
            },
            dataType: 'json',
            cache: false
        });
        request.done(function(json) {
            if(json['success'] =='completed') {
                Swal.fire({
                    html: json['html'],
                    showConfirmButton: false,
                    allowOutsideClick: false
                });
            }
        });
    };

    wlpr.showNewCustomer = function () {
        var request = wlpr_jquery.ajax({
            url: wlpr_localize_data.ajax_url,
            type: 'get',
            data: {
                action: 'wlpr_new_customer_popup',
                wlpr_none: wlpr_localize_data.wlpr_popup_none
            },
            dataType: 'json',
            cache: false
        });
        request.done(function(json) {
            if(json['success'] =='completed') {
                Swal.fire({
                    html: json['html'],
                    showConfirmButton: false,
                    allowOutsideClick: false
                });
            }
        });
    };

    wlpr.showImportPre = function () {
        var form = wlpr_jquery('#import_user_point_form');
        var formData = new FormData(form[0]);
        var request = wlpr_jquery.ajax({
            url: wlpr_localize_data.ajax_url,
            type: 'post',
            data: formData,
            dataType: 'json',
            processData: false,  /* Important!*/
            contentType: false,
            cache: false,
        });
        request.done(function(json) {
            if(json['success'] =='completed') {
                Swal.fire({
                    html: json['html'],
                    showConfirmButton: false,
                    allowOutsideClick: false
                });
            }
        });
    };
    wlpr.update_expire_date = function (id,page_name) {
        var expire_date = wlpr_jquery('#expire-date-edit-'+id+' #expire_date_id_'+id).val();
        wlpr_jquery.ajax({
            data: {expire_date: expire_date,page: page_name,action: 'wlpr_update_expire_date', action_id: id,wlpr_none: wlpr_localize_data.wlpr_update_expire_date_none},
            type: 'post',
            url: wlpr_localize_data.ajax_url,
            error: function (request, error) {
                /*alertify.error(error);*/
                console.log(error);
            },
            success: function (json) {

                if (json.error) {
                    alertify.error(json.message);
                } else {
                    alertify.success(json.message);
                    window.location.reload();
                }
            }
        });
    };
    wlpr.showEarnPointDiv = function () {
        var current_value = wlpr_jquery(this).val();
        if(current_value == 'global'){
            wlpr_jquery('.wlpr-earn-point-settings').show();
            wlpr_jquery('.wlpr-earn-point-disable-msg').hide();
        }
        if(current_value == 'disable'){
            wlpr_jquery('.wlpr-earn-point-disable-msg').show();
            wlpr_jquery('.wlpr-earn-point-settings').hide();
        }
        if(current_value == 'product'){
            wlpr_jquery('.wlpr-earn-point-disable-msg').hide();
            wlpr_jquery('.wlpr-earn-point-settings').show();
        }
    };
})(wlpr);
(function () {
    wlpr_jquery(document).on('submit', '#validate_license_key_form_modal', function (e) {
        e.preventDefault();
        let validate_btn = wlpr_jquery(this).find(':submit');
        validate_btn.html(wlpr_localize_data.localize_validating);
        validate_btn.attr('disabled', true);
        wlpr_jquery('.license_key_message').html("");
        wlpr_jquery('.license_key_message').css({"color": ""});
        wlpr_jquery.ajax({
            data: wlpr_jquery(this).serialize(),
            type: 'post',
            url: wlpr_localize_data.ajax_url,
            error: function (request, error) {
                /*alertify.error(error);*/
                console.log(error);
            },
            success: function (json) {
                wlpr_jquery('#wlpr-referral-submit-button').attr('disabled', false);
                if (json.license_key) {
                    window.location.reload();
                    wlpr_jquery('.license_key_message').css('color','green');
                    wlpr_jquery('.license_key_message').html(json.license_key_message)
                }else if(json.license_key_message){
                    wlpr_jquery('.license_key_message').css('color','red');
                    wlpr_jquery('.license_key_message').html(json.license_key_message)
                }
            }
        });
        validate_btn.attr('disabled', false);
        validate_btn.html(wlpr_localize_data.localize_validate);
    });
    alertify.set('notifier', 'position', 'top-right');
    /* In your Javascript (external .js resource or <script> tag)*/
    wlpr_jquery(document).ready(function() {
        wlpr_jquery('.lpr-form-multselect').select2();
        wlpr_jquery('#wlpr-main .wlpr-color-field').wpColorPicker();
    });
    wlpr_jquery(document).on('change','#wlpr_cart_earn_point_display',function () {
        let earn_display_type = wlpr_jquery(this).val();
        if(earn_display_type == 'summary'){
            wlpr_jquery('.wlpr-earn-point-order-summary-text').show();
        }else {
            wlpr_jquery('.wlpr-earn-point-order-summary-text').hide();
        }
    });
})(wlpr_jquery);
