<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */
$points_label = isset($points_label) ? $points_label: '';
$share_content = isset($share_content) ? $share_content : '';
$share_subject = (isset($share_subject) && !empty($share_subject)) ? $share_subject : '';
$email_subject = preg_replace('/\s\s+/', '%0D%0A', $share_subject);
$email_content = preg_replace('/\s\s+/', '%0D%0A', $share_content);
$email_subject = str_replace(array("'",'"'),array('%27','%22'),$email_subject);
$email_content = str_replace(array("'",'"'),array('%27','%22'),$email_content);
$url = (isset($url) && !empty($url)) ? $url : '';

?>
<style>
    .woocommerce-MyAccount-navigation-link--loyalty {

    }

    .lpr-recent-points table {
        border-color: #e1e2ea;
        margin-top: 22px;
    }

    .lpr-recent-points tr th {
        font-weight: 600;
        background: #f6f8f9;
        font-size: 15px;
        padding: 12px 10px;
        color: #333;
        background: none !important;
    }

    .lpr-recent-points tr td a {
        color: #353d9f;
        text-decoration: none;
        font-weight: 600;
    }

    .lpr-recent-points th, td {
        border: 1px solid #e1e2ef;
    }

    .lpr-recent-points tr td {
        padding: 17px 10px;
        font-size: 15px;
        color: #212b36;
    }

    .lpr-recent-points h3 {
        margin: 1rem auto 3rem;
        font-size: 20px;
        line-height: 1rem;
        font-weight: 600;
        color: #000;
        letter-spacing: 0.3px;
        margin-bottom: 6px;
        border-bottom: 1px solid #e4e6f0;
        padding-bottom: 25px;
    }

    .lpr-recent-points .points-box {
        background: #f6f8f9;
        width: 100%;
        border: 1px solid #e7e9f3;
        border-radius: 5px;
        box-shadow: 0 1px 5px rgba(88, 95, 99, 0.06);
        padding: 20px 20px;
        margin-bottom: 25px;
        position: relative;
    }

    .lpr-recent-points .points-box p {
        display: inline-block;
        font-size: 16px;
        margin-bottom: -6px;
        font-weight: 500;
        color: #474751;
        text-transform: capitalize;
        padding-top: 0px;
    }

    .lpr-recent-points .points-box strong {
        color: #353d9f;
        font-size: 40px;
    }

    .lpr-recent-points .referral_url {
        background: none 0% 0% repeat scroll rgba(58, 157, 93, 0.21);
        border: 1px dashed rgb(58, 157, 93);
        color: rgb(0, 132, 47);
        border-radius: 5px;
        padding: 6px 15px;
        margin-top: 22px;
        margin-bottom: 10px;
        font-size: 17px;
        height: 44px;
        width: 100%;
    }

    .lpr-recent-points .referral_url:focus {
        border: 1px dashed rgb(58, 157, 93) !important;
        border-radius: 5px;
        margin-top: 22px;
        margin-bottom: 10px;
        box-shadow: 0 3px 6px rgba(88, 95, 99, 0.1) !important;
    }

    .lpr-recent-points .bdr-none {
        border: 0 solid #e1e2ef;
        margin-bottom: 0;
        padding-bottom: 0;
        margin-top: 50px;
        line-height: 24px;
        font-size: 22px;
    }

    .lpr-recent-points .points-box .lpr-referral-text {
        display: block;
        font-size: 17px;
        margin-bottom: 24px;
        font-weight: 500;
        color: #000;
        position: relative;
        border: 1px solid #e7e9f3;
        padding: 12px 20px;
        border-radius: 6px;
        background: #f6f8f9;

    }

    .lpr-recent-points .lpr-bg {
        background: none;
        border: 0 solid #e7e9f3;
        border-radius: 5px;
        box-shadow: none;
        padding: 0;
    }

    .lpr-recent-points .lpr-icon-list {
        display: inline-block;
        padding-right: 6%;
        text-align: center;
        color: #000;
        text-decoration: none !important;
        font-size: 16px;
        margin-top: 25px;
        margin-bottom: 14px
    }

    .lpr-text-center {
        text-align: center;
    }

    .lpr-recent-points .lpr-icon-list span {
        display: block;
    }

    .lpr-recent-points .lpr-icon-list i {
        font-size: 22px;
        margin-bottom: 10px;
    }

    .input-group-append {
        margin-left: -1px;
        display: flex;
    }

    .input-group-text {
        display: flex;
        align-items: center;
        margin-bottom: 0;
        font-weight: 400;
        text-align: center;
        white-space: nowrap;
        cursor: pointer;
        background: rgb(58, 157, 93);
        border: 1px solid rgb(58, 157, 93);
        color: rgb(255, 255, 255);
        border-radius: 4px;
        position: absolute;
        top: 42px;
        right: 18px;
        width: 46px;
        height: 44px;
        font-size: 18px;
        border-top-left-radius: 0;
        border-bottom-left-radius: 0;
        padding: 9px 15px;
        line-height: 20px;
    }

    .lpr-recent-points .pagination {
        display: inline-block;
        margin: 0;
        float: left;
        padding: 5px 0;
    }

    .lpr-recent-points .pagination li {
        display: inline-block;
        padding-left: 0;
        list-style: none;
        margin: 0;
        border-radius: 8px;

    }

    .lpr-recent-points .pagination li a {
        position: relative;
        font-size: 14px;
        font-weight: 600;
        margin-left: -1px;
        line-height: 1.25;
        color: #353d9f;
        background-color: #fff;
        border: 1px solid #ddd;
        padding: 9px 18px;
        text-decoration: none !important;
    }

    .lpr-recent-points .pagination li a.active {
        background-color: #353d9f;
        border-color: #353d9f;
        color: #fff;
        padding: 9px 16px;
        font-size: 14px;
        font-weight: 600;
    }

    .lpr-recent-points .dataTables_info {
        padding-top: 10px;
        float: right;
        font-weight: 500;
    }
</style>

<section class="full-width">
    <div class="lpr-recent-section lpr-point-history">
        <div class="side-elements lpr-recent-points">
            <div class="points-box">
                <h3><?php esc_html_e('Your Points', WLPR_TEXT_DOMAIN); ?></h3>
                <?php
                $usr_point = (isset($user_point->points) && !empty($user_point->points)) ? $user_point->points : 0;
                $ref_code = (isset($user_point->refer_code) && !empty($user_point->refer_code)) ? $user_point->refer_code : '';

                ?>
                <p><?php echo sprintf(__(' <strong>%s</strong> %s', WLPR_TEXT_DOMAIN), $usr_point, $points_label); ?></p>

            </div>
            <?php if(isset($wlpr_enable_referral) && $wlpr_enable_referral == 'yes'):?>
            <div class="points-box lpr-bg">
                <?php if (!empty($ref_code)): ?>
                <?php if(isset($referrer_message) && !empty($referrer_message)): ?>
                <div class="wlpr-referrer-message lpr-referral-text"><?php echo (isset($referrer_message) && !empty($referrer_message)) ? $referrer_message : ''; ?></div>
                <?php endif; ?>
                <?php if(isset($referee_message) && !empty($referee_message)): ?>
                <div class="wlpr-referee-message lpr-referral-text"><?php echo (isset($referee_message) && !empty($referee_message)) ? $referee_message : ''; ?></div>
                <?php endif; ?>
                <?php if(isset($referee_discount_message) && !empty($referee_discount_message)): ?>
                <div class="wlpr-referee-discount-message lpr-referral-text"><?php echo (isset($referee_discount_message) && !empty($referee_discount_message)) ? $referee_discount_message : ''; ?></div>
                <?php endif; ?>
                <?php $before_referral_content = '';
                echo apply_filters('wlpr_before_referral_content',$before_referral_content);
                ?>
                <div class="points-box lpr-text-center">
                    <!-- The text field -->
                    <input type="text" value="<?php echo $url; ?>" id="referral_url_link" class="referral_url">
                    <div class="input-group-append" onclick="wlpr.copyLink('referral_url_link')"><span
                                class="input-group-text"><i class="wlpr wlpr-clone"></i></span></div>
                    <?php if (isset($enable_facebook_share) && $enable_facebook_share == 'yes'): ?>
                        <?php  //$facebook_url = "https://www.facebook.com/dialog/share?quote=".urlencode($share_content)."&app_id=".$facebook_app_id."&display=page&href=".urlencode($url)."&redirect_uri=".urlencode(site_url());
                        $facebook_url = "https://www.facebook.com/sharer/sharer.php?quote=".urlencode($share_content)."&u=".urlencode($url)."&display=page";
                        ?>
                        <a class="lpr-icon-list" onClick="wlpr.shareFB('<?php echo $facebook_url; ?>')" target="_parent"
                           href="javascript: void(0)"><i
                                    class="wlpr wlpr-facebook"></i><span><?php echo __('Facebook', WLPR_TEXT_DOMAIN) ?></span></a>
                    <?php endif; ?>
                    <?php if (isset($enable_twitter_share) && $enable_twitter_share == 'yes'): ?>
                    <a class="lpr-icon-list"
                       onClick="wlpr.twitterShare('https://twitter.com/intent/tweet?text=<?php echo urlencode($share_content); ?>');"
                       target="_parent" href="javascript: void(0)"><i
                                class="wlpr wlpr-twitter"></i><span><?php echo __('Twitter', WLPR_TEXT_DOMAIN) ?></span></a>
                    <?php endif; ?>
                    <?php $email_url = "mailto:?subject=".$email_subject."&amp;body=".$email_content; ?>
                    <?php if (isset($enable_email_share) && $enable_email_share == 'yes'): ?>
                    <a class="lpr-icon-list" onclick="wlpr.emailShare('<?php echo $email_url;?>')"><i
                                class="wlpr wlpr-envelope"></i><span><?php echo __('Email', WLPR_TEXT_DOMAIN) ?></span></a>
                    <?php endif; ?>
                    <?php if (isset($enable_whatsapp_share) && $enable_whatsapp_share == 'yes'): ?>
                    <a class="lpr-icon-list" onclick="wlpr.whatsAppShare('<?php echo 'https://api.whatsapp.com/send?text='.urlencode($share_content);?>')"><i
                                class="wlpr wlpr-whatsapp"></i><span><?php echo __('WhatsApp', WLPR_TEXT_DOMAIN) ?></span></a>
                    <?php endif; ?>
                    <?php else: ?>
                        <p><?php echo (isset($before_referral_message) && !empty($before_referral_message)) ? $before_referral_message : ''; ?></p>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
            <h3 class="lpr-mb-15 bdr-none"><?php esc_html_e('Transaction', WLPR_TEXT_DOMAIN); ?></h3>
            <table>
                <tr>
                    <th><?php esc_html_e('Date', WLPR_TEXT_DOMAIN); ?></th>
                    <th><?php esc_html_e('Event', WLPR_TEXT_DOMAIN); ?></th>
                    <th><?php esc_html_e('Points', WLPR_TEXT_DOMAIN); ?></th>
                </tr>
                <?php if (isset($transaction) && !empty($transaction) && isset($point_helper)): ?>
                    <?php foreach ($transaction as $item): ?>
                        <tr>
                            <td class="lpr-table-date">
                                <!-- Date -->
                                <?php echo date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime(\Wlpr\App\Helpers\Loyalty::woocommerce()->convert_utc_to_wp_time($item->created_date))); ?>
                                <!-- Type -->
                                <br/>
                                <?php esc_html_e('Type:', WLPR_TEXT_DOMAIN); ?>
                                <?php
                                if (in_array($item->action, array('order-placed', 'order-cancelled', 'order-refunded', 'order-redeem'))):
                                    $order = \Wlpr\App\Helpers\Loyalty::woocommerce()->getOrder($item->order_id);
                                    if (!empty($order)):
                                        ?>
                                        <a href="<?php echo $order->get_view_order_url(); ?>"><?php esc_html_e('Order #', WLPR_TEXT_DOMAIN); ?><?php echo \Wlpr\App\Helpers\Loyalty::woocommerce()->getDisplayOrderId($item->order_id); ?></a>
                                    <?php else: ?>
                                        <?php esc_html_e('Order #', WLPR_TEXT_DOMAIN); ?><?php echo \Wlpr\App\Helpers\Loyalty::woocommerce()->getDisplayOrderId($item->order_id); ?>
                                    <?php endif; ?>
                                <?php elseif ($item->action == 'admin-adjustment'): ?>
                                    <?php esc_html_e('Admin adjusted', WLPR_TEXT_DOMAIN); ?>
                                <?php elseif ($item->action == 'rest-api'): ?>
                                    <?php esc_html_e('REST Api adjusted', WLPR_TEXT_DOMAIN); ?>
                                <?php elseif ($item->action == 'expire'): ?>
                                    <?php esc_html_e('Expired', WLPR_TEXT_DOMAIN); ?>
                                <?php elseif ($item->action == 'product-review'): ?>
                                    <?php esc_html_e('Review', WLPR_TEXT_DOMAIN); ?>
                                <?php elseif ($item->action == 'account-signup'): ?>
                                    <?php esc_html_e('Signup', WLPR_TEXT_DOMAIN); ?>
                                <?php elseif ($item->action == 'referring_user'): ?>
                                    <?php esc_html_e('Points earned through referral', WLPR_TEXT_DOMAIN); ?>
                                <?php elseif ($item->action == 'referral_point'): ?>
                                    <?php esc_html_e('Referred some one', WLPR_TEXT_DOMAIN); ?>
                                <?php elseif ($item->action == 'birth_date'): ?>
                                    <?php esc_html_e('Birthday date update', WLPR_TEXT_DOMAIN); ?>
                                <?php elseif ($item->action == 'on_birth_date'): ?>
                                    <?php esc_html_e('Birthday gift', WLPR_TEXT_DOMAIN); ?>
                                <?php elseif ($item->action == 'facebook_share'): ?>
                                    <?php esc_html_e('Facebook Share', WLPR_TEXT_DOMAIN); ?>
                                <?php elseif ($item->action == 'twitter_share'): ?>
                                    <?php esc_html_e('Twitter Share', WLPR_TEXT_DOMAIN); ?>
                                <?php elseif ($item->action == 'email_share'): ?>
                                    <?php esc_html_e('Sending Email', WLPR_TEXT_DOMAIN); ?>
                                <?php elseif ($item->action == 'whatsapp_share'): ?>
                                    <?php esc_html_e('WhatsApp Share', WLPR_TEXT_DOMAIN); ?>
                                <?php elseif ($item->action == 'import'): ?>
                                    <?php esc_html_e('Import', WLPR_TEXT_DOMAIN); ?>
                                <?php endif; ?>
                                <br/>
                                <?php esc_html_e('Email:', WLPR_TEXT_DOMAIN); ?>
                                <?php echo $item->user_email; ?>
                               <?php if ( $item->expire_date > 0 && in_array($item->expire_status,array('active','expired'))): ?>
                                    <br/>
                                    <?php if($item->expire_date < date('Y-m-d H:i:s')):?>
                                       <?php esc_html_e('Expired Date:', WLPR_TEXT_DOMAIN); ?>
                                    <?php else:?>
                                       <?php esc_html_e('Upcoming Expire Date:', WLPR_TEXT_DOMAIN); ?>
                                   <?php endif;?>

                                    <?php echo date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime(\Wlpr\App\Helpers\Loyalty::woocommerce()->convert_utc_to_wp_time($item->expire_date, 'Y-m-d H:i:s'))); ?>
                                <?php endif; ?>
                            </td>
                            <td><?php echo $point_helper->eventTypeDescription($item->action); ?></td>
                            <td class="lpr-points-green"><?php echo $item->points; ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="5"><?php esc_html_e('No transaction found', WLPR_TEXT_DOMAIN); ?></td>
                    </tr>
                <?php endif; ?>
                <?php if (isset($transaction_pagination)): ?>
                    <tr>
                        <td colspan="5"><?php echo $transaction_pagination->createLinks(array('page_number_name' => 'transaction_page_number')); ?></td>
                    </tr>
                <?php endif; ?>
            </table>
        </div>
    </div>
</section>
